/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitor;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "", "Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;", "()V", "visitAnnotationValue", "value", "Lorg/jetbrains/kotlin/resolve/constants/AnnotationValue;", "data", "visitArrayValue", "Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "visitBooleanValue", "Lorg/jetbrains/kotlin/resolve/constants/BooleanValue;", "visitByteValue", "Lorg/jetbrains/kotlin/resolve/constants/ByteValue;", "visitCharValue", "Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "visitDoubleValue", "Lorg/jetbrains/kotlin/resolve/constants/DoubleValue;", "visitEnumValue", "Lorg/jetbrains/kotlin/resolve/constants/EnumValue;", "visitErrorValue", "Lorg/jetbrains/kotlin/resolve/constants/ErrorValue;", "visitFloatValue", "Lorg/jetbrains/kotlin/resolve/constants/FloatValue;", "visitIntValue", "Lorg/jetbrains/kotlin/resolve/constants/IntValue;", "visitKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "visitLongValue", "Lorg/jetbrains/kotlin/resolve/constants/LongValue;", "visitNullValue", "Lorg/jetbrains/kotlin/resolve/constants/NullValue;", "visitShortValue", "Lorg/jetbrains/kotlin/resolve/constants/ShortValue;", "visitStringValue", "Lorg/jetbrains/kotlin/resolve/constants/StringValue;", "visitUByteValue", "Lorg/jetbrains/kotlin/resolve/constants/UByteValue;", "visitUIntValue", "Lorg/jetbrains/kotlin/resolve/constants/UIntValue;", "visitULongValue", "Lorg/jetbrains/kotlin/resolve/constants/ULongValue;", "visitUShortValue", "Lorg/jetbrains/kotlin/resolve/constants/UShortValue;", "fir-serialization"})
public final class FirAnnotationArgumentVisitor
implements AnnotationArgumentVisitor<Unit, FirAnnotationArgumentVisitorData> {
    public static final FirAnnotationArgumentVisitor INSTANCE;

    @Override
    public void visitAnnotationValue(@NotNull AnnotationValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
    }

    @Override
    public void visitArrayValue(@NotNull ArrayValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
        for (ConstantValue element : (List)value2.getValue()) {
            data.getBuilder().addArrayElement(data.getSerializer().valueProto(element).build());
        }
    }

    @Override
    public void visitBooleanValue(@NotNull BooleanValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
        data.getBuilder().setIntValue((Boolean)value2.getValue() != false ? 1L : 0L);
    }

    @Override
    public void visitByteValue(@NotNull ByteValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data.getBuilder().setIntValue(((Number)value2.getValue()).byteValue());
    }

    @Override
    public void visitCharValue(@NotNull CharValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
        data.getBuilder().setIntValue(((Character)value2.getValue()).charValue());
    }

    @Override
    public void visitDoubleValue(@NotNull DoubleValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
        data.getBuilder().setDoubleValue(((Number)value2.getValue()).doubleValue());
    }

    @Override
    public void visitEnumValue(@NotNull EnumValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
        data.getBuilder().setClassId(data.getStringTable().getQualifiedClassNameIndex(value2.getEnumClassId()));
        ProtoBuf.Annotation.Argument.Value.Builder builder = data.getBuilder();
        FirElementAwareStringTable firElementAwareStringTable = data.getStringTable();
        String string2 = value2.getEnumEntryName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.enumEntryName.asString()");
        builder.setEnumValueId(firElementAwareStringTable.getStringIndex(string2));
    }

    @Override
    public void visitErrorValue(@NotNull ErrorValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        throw (Throwable)new UnsupportedOperationException("Error value: " + value2);
    }

    @Override
    public void visitFloatValue(@NotNull FloatValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
        data.getBuilder().setFloatValue(((Number)value2.getValue()).floatValue());
    }

    @Override
    public void visitIntValue(@NotNull IntValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data.getBuilder().setIntValue(((Number)value2.getValue()).intValue());
    }

    @Override
    public void visitKClassValue(@NotNull KClassValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        block3: {
            KClassValue.Value classValue;
            block2: {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
                classValue = (KClassValue.Value)value2.getValue();
                if (!(classValue instanceof KClassValue.Value.NormalClass)) break block2;
                data.getBuilder().setClassId(data.getStringTable().getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
                if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() <= 0) break block3;
                data.getBuilder().setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
                break block3;
            }
            if (!(classValue instanceof KClassValue.Value.LocalClass)) break block3;
            int arrayDimensions = 0;
            KotlinType type2 = ((KClassValue.Value.LocalClass)classValue).getType();
            while (KotlinBuiltIns.isArray(type2)) {
                ++arrayDimensions;
                Intrinsics.checkNotNullExpressionValue((Object)((TypeProjection)CollectionsKt.single(type2.getArguments())).getType(), (String)"type.arguments.single().type");
            }
            if (arrayDimensions > 0) {
                data.getBuilder().setArrayDimensionCount(arrayDimensions);
            }
        }
    }

    @Override
    public void visitLongValue(@NotNull LongValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data.getBuilder().setIntValue(((Number)value2.getValue()).longValue());
    }

    @Override
    public void visitNullValue(@NotNull NullValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        throw (Throwable)new UnsupportedOperationException("Null should not appear in annotation arguments");
    }

    @Override
    public void visitShortValue(@NotNull ShortValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data.getBuilder().setIntValue(((Number)value2.getValue()).shortValue());
    }

    @Override
    public void visitStringValue(@NotNull StringValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
        data.getBuilder().setStringValue(data.getStringTable().getStringIndex((String)value2.getValue()));
    }

    @Override
    public void visitUByteValue(@NotNull UByteValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data.getBuilder().setIntValue(((Number)value2.getValue()).byteValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitUShortValue(@NotNull UShortValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data.getBuilder().setIntValue(((Number)value2.getValue()).shortValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitUIntValue(@NotNull UIntValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data.getBuilder().setIntValue(((Number)value2.getValue()).intValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitULongValue(@NotNull ULongValue value2, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data.getBuilder().setIntValue(((Number)value2.getValue()).longValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    private FirAnnotationArgumentVisitor() {
    }

    static {
        FirAnnotationArgumentVisitor firAnnotationArgumentVisitor;
        INSTANCE = firAnnotationArgumentVisitor = new FirAnnotationArgumentVisitor();
    }
}

