/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.KaptExecution;
import org.jetbrains.kotlin.gradle.internal.KaptOptionsForWorker;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0007R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00128GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188G\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u00020\r8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R(\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00128GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0014\"\u0004\b#\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/gradle/internal/KaptWithoutKotlincTask;", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "annotationProcessorFqNames", "", "", "getAnnotationProcessorFqNames", "()Ljava/util/List;", "setAnnotationProcessorFqNames", "(Ljava/util/List;)V", "isVerbose", "", "()Z", "setVerbose", "(Z)V", "javacOptions", "", "getJavacOptions", "()Ljava/util/Map;", "setJavacOptions", "(Ljava/util/Map;)V", "kaptJars", "", "Ljava/io/File;", "kaptJars$annotations", "()V", "getKaptJars", "()Ljava/util/Collection;", "mapDiagnosticLocations", "getMapDiagnosticLocations", "setMapDiagnosticLocations", "processorOptions", "getProcessorOptions", "setProcessorOptions", "compile", "", "inputs", "Lorg/gradle/api/tasks/incremental/IncrementalTaskInputs;", "kotlin-gradle-plugin"})
public class KaptWithoutKotlincTask
extends KaptTask {
    private boolean isVerbose;
    private boolean mapDiagnosticLocations;
    @NotNull
    public List<String> annotationProcessorFqNames;
    @NotNull
    public Map<String, String> processorOptions;
    @NotNull
    public Map<String, String> javacOptions;
    private final WorkerExecutor workerExecutor;

    public static /* synthetic */ void kaptJars$annotations() {
    }

    @InputFiles
    @Classpath
    @NotNull
    public final Collection<File> getKaptJars() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Set set = project.getConfigurations().getByName("kotlinKaptWorkerDependencies").resolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"project.configurations.g\u2026IGURATION_NAME).resolve()");
        return set;
    }

    @Input
    public final boolean isVerbose() {
        return this.isVerbose;
    }

    public final void setVerbose(boolean bl) {
        this.isVerbose = bl;
    }

    @Input
    public final boolean getMapDiagnosticLocations() {
        return this.mapDiagnosticLocations;
    }

    public final void setMapDiagnosticLocations(boolean bl) {
        this.mapDiagnosticLocations = bl;
    }

    @Input
    @NotNull
    public final List<String> getAnnotationProcessorFqNames() {
        List<String> list2 = this.annotationProcessorFqNames;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        return list2;
    }

    public final void setAnnotationProcessorFqNames(@NotNull List<String> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.annotationProcessorFqNames = list2;
    }

    @Input
    @NotNull
    public final Map<String, String> getProcessorOptions() {
        Map<String, String> map2 = this.processorOptions;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processorOptions");
        }
        return map2;
    }

    public final void setProcessorOptions(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.processorOptions = map2;
    }

    @Input
    @NotNull
    public final Map<String, String> getJavacOptions() {
        Map<String, String> map2 = this.javacOptions;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javacOptions");
        }
        return map2;
    }

    public final void setJavacOptions(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.javacOptions = map2;
    }

    @TaskAction
    public final void compile(@NotNull IncrementalTaskInputs inputs) {
        boolean bl;
        boolean $i$f$none22;
        List compileClasspath;
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)inputs, (String)"inputs");
            this.getLogger().info("Running kapt annotation processing using the Gradle Worker API");
            this.checkAnnotationProcessorClasspath();
            Set set = this.getClasspath().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"classpath.files");
            compileClasspath = CollectionsKt.toMutableList((Collection)set);
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            PluginContainer pluginContainer = project.getPlugins();
            Intrinsics.checkExpressionValueIsNotNull((Object)pluginContainer, (String)"project.plugins");
            Iterable $this$none$iv = (Iterable)pluginContainer;
            $i$f$none22 = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Plugin it = (Plugin)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof KotlinAndroidPluginWrapper)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            compileClasspath.addAll(0, PathUtil.getJdkClassesRootsFromCurrentJre());
        }
        $i$f$none22 = false;
        Set $i$f$none22 = new LinkedHashSet();
        boolean bl3 = false;
        boolean bl4 = false;
        Set $receiver = $i$f$none22;
        boolean bl5 = false;
        if (this.isVerbose) {
            $receiver.add("VERBOSE");
        }
        if (this.mapDiagnosticLocations) {
            $receiver.add("MAP_DIAGNOSTIC_LOCATIONS");
        }
        if (this.getIncludeCompileClasspath$kotlin_gradle_plugin()) {
            $receiver.add("INCLUDE_COMPILE_CLASSPATH");
        }
        Set kaptFlagsForWorker = $i$f$none22;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        List list2 = CollectionsKt.toList((Iterable)this.getJavaSourceRoots());
        List<File> list3 = this.getChangedFiles(inputs);
        List<File> list4 = this.getCompiledSources();
        File file2 = this.getIncAptCache();
        File file3 = (File)CollectionsKt.singleOrNull((Iterable)((Iterable)this.getClasspathDirtyFqNamesHistoryDir$kotlin_gradle_plugin()));
        File file4 = this.getDestinationDir();
        File file5 = this.getClassesDir$kotlin_gradle_plugin();
        File file6 = this.getStubsDir$kotlin_gradle_plugin();
        Set set = this.getKaptClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"kaptClasspath.files");
        List list5 = CollectionsKt.toList((Iterable)set);
        List<String> list6 = this.annotationProcessorFqNames;
        if (list6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        Map<String, String> map2 = this.processorOptions;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processorOptions");
        }
        Map<String, String> map3 = this.javacOptions;
        if (map3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javacOptions");
        }
        KaptOptionsForWorker optionsForWorker = new KaptOptionsForWorker(file, compileClasspath, list2, list3, list4, file2, file3, file4, file5, file6, list5, list6, map2, map3, kaptFlagsForWorker);
        List<String> list7 = this.annotationProcessorFqNames;
        if (list7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        if (list7.isEmpty() && this.getKaptClasspath().isEmpty()) {
            return;
        }
        Collection<File> collection = this.getKaptJars();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List kaptClasspath = CollectionsKt.plus(collection, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project2));
        this.workerExecutor.submit(KaptExecution.class, (Action)new Action<WorkerConfiguration>(this, optionsForWorker, kaptClasspath){
            final /* synthetic */ KaptWithoutKotlincTask this$0;
            final /* synthetic */ KaptOptionsForWorker $optionsForWorker;
            final /* synthetic */ List $kaptClasspath;

            public final void execute(WorkerConfiguration config) {
                IsolationMode isolationMode;
                String string;
                String string2 = (String)this.this$0.getProject().findProperty("kapt.workers.isolation");
                if (string2 == null) {
                    string2 = "none";
                }
                String isolationModeStr = string2;
                WorkerConfiguration workerConfiguration = config;
                Intrinsics.checkExpressionValueIsNotNull((Object)workerConfiguration, (String)"config");
                String string3 = isolationModeStr;
                WorkerConfiguration workerConfiguration2 = workerConfiguration;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                switch (string = string5) {
                    case "process": {
                        isolationMode = IsolationMode.PROCESS;
                        break;
                    }
                    case "none": {
                        isolationMode = IsolationMode.NONE;
                        break;
                    }
                    default: {
                        isolationMode = IsolationMode.NONE;
                    }
                }
                workerConfiguration2.setIsolationMode(isolationMode);
                config.params(new Object[]{this.$optionsForWorker, JarSearchingUtilKt.findToolsJar(), this.$kaptClasspath});
                if (Intrinsics.areEqual((Object)this.this$0.getProject().findProperty("kapt.workers.log.classloading"), (Object)"true")) {
                    config.getForkOptions().jvmArgs(new Object[]{"-verbose:class"});
                }
                this.this$0.getLogger().info("Kapt worker classpath: " + config.getClasspath());
            }
            {
                this.this$0 = kaptWithoutKotlincTask;
                this.$optionsForWorker = kaptOptionsForWorker;
                this.$kaptClasspath = list2;
            }
        });
    }

    @Inject
    public KaptWithoutKotlincTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }
}

