/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt$WhenMappings;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u001aA\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\fH\u0000\u00a2\u0006\u0002\u0010\u0014\u001a#\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\tH\u0000\u00a8\u0006\u001b"}, d2={"createLoggingMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "exitCodeFromProcessExitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "code", "", "loadCompilerVersion", "", "compilerClasspath", "", "Ljava/io/File;", "runToolInSeparateProcess", "argsArray", "", "compilerClassName", "classpath", "logger", "buildDir", "([Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/io/File;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "writeArgumentsToFile", "directory", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "logFinish", "", "strategy", "kotlin-gradle-plugin"})
public final class ReportUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final String loadCompilerVersion(@NotNull List<? extends File> compilerClasspath2) {
        String string;
        void result2;
        Intrinsics.checkParameterIsNotNull(compilerClasspath2, (String)"compilerClasspath");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function1<byte[], Unit> $fun$checkVersion$1 = new Function1<byte[], Unit>((Ref.ObjectRef)result2){
            final /* synthetic */ Ref.ObjectRef $result;

            public final void invoke(@NotNull byte[] bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                new ClassReader(bytes).accept(new ClassVisitor(this, 524288){
                    final /* synthetic */ loadCompilerVersion.1 this$0;

                    @NotNull
                    public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                        if (Intrinsics.areEqual((Object)name, (Object)"VERSION") && value instanceof String) {
                            this.this$0.$result.element = (String)value;
                        }
                        FieldVisitor fieldVisitor = super.visitField(access, name, desc, signature, value);
                        Intrinsics.checkExpressionValueIsNotNull((Object)fieldVisitor, (String)"super.visitField(access,\u2026, desc, signature, value)");
                        return fieldVisitor;
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1);
                    }
                }, 7);
            }
            {
                this.$result = objectRef;
                super(1);
            }
        };
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = KotlinCompilerVersion.class.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KotlinCompilerVersion::class.java.name");
            String versionClassFileName = stringBuilder.append(StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
            for (File file : compilerClasspath2) {
                if (file.isFile()) {
                    Object object = FilesKt.getExtension((File)file);
                    boolean bl = false;
                    String string3 = object;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    if (Intrinsics.areEqual((Object)string4, (Object)"jar")) {
                        object = new ZipFile(file);
                        bl = false;
                        Throwable throwable = null;
                        try {
                            Object object2;
                            ZipFile jar = (ZipFile)object;
                            boolean bl2 = false;
                            ZipEntry versionFileEntry = jar.getEntry("/META-INF/compiler.version");
                            if (versionFileEntry != null) {
                                Object object3;
                                InputStream inputStream = jar.getInputStream(versionFileEntry);
                                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"jar.getInputStream(versionFileEntry)");
                                Closeable closeable = inputStream;
                                Charset charset = Charsets.UTF_8;
                                boolean bl3 = false;
                                object2 = closeable;
                                int n = 0;
                                object2 = new InputStreamReader((InputStream)object2, charset);
                                n = 8192;
                                boolean bl4 = false;
                                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                                void var18_35 = result2;
                                boolean bl5 = false;
                                Throwable throwable2 = null;
                                try {
                                    BufferedReader it = (BufferedReader)closeable;
                                    boolean bl6 = false;
                                    object2 = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                                }
                                var18_35.element = object3 = object2;
                            } else {
                                byte[] byArray;
                                Closeable closeable = jar.getInputStream(jar.getEntry(versionClassFileName));
                                boolean bl7 = false;
                                object2 = null;
                                try {
                                    InputStream it = (InputStream)closeable;
                                    boolean bl8 = false;
                                    InputStream inputStream = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                                    byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
                                }
                                catch (Throwable throwable4) {
                                    object2 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                                }
                                byte[] bytes = byArray;
                                $fun$checkVersion$1.invoke(bytes);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                    }
                }
                if (file.isDirectory()) {
                    File versionFile = new File(file, "/META-INF/compiler.version");
                    if (versionFile.isFile()) {
                        result2.element = FilesKt.readText$default((File)versionFile, null, (int)1, null);
                    } else {
                        File file2 = new File(file, versionClassFileName);
                        boolean bl = false;
                        boolean bl9 = false;
                        File it = file2;
                        boolean bl10 = false;
                        File file3 = it.isFile() ? file2 : null;
                        if (file3 != null) {
                            file2 = file3;
                            bl = false;
                            bl9 = false;
                            it = file2;
                            boolean bl11 = false;
                            $fun$checkVersion$1.invoke(FilesKt.readBytes((File)it));
                        }
                    }
                }
                if ((String)result2.element == null) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if ((string = (String)result2.element) == null) {
            string = "<unknown>";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExitCode runToolInSeparateProcess(@NotNull String[] argsArray, @NotNull String compilerClassName, @NotNull List<? extends File> classpath2, @NotNull KotlinLogger logger, @NotNull File buildDir2) {
        Charset charset;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)argsArray, (String)"argsArray");
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)buildDir2, (String)"buildDir");
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        Iterable $this$map$iv = classpath2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        String classpathString = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        File compilerOptions = ReportUtilsKt.writeArgumentsToFile(buildDir2, argsArray);
        ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpathString, compilerClassName, '@' + compilerOptions.getAbsolutePath());
        MessageCollector messageCollector = ReportUtilsKt.createLoggingMessageCollector(logger);
        Process process = NativePlatformUtilKt.launchProcessWithFallback$default((ProcessBuilder)builder, (DaemonReportingTargets)new DaemonReportingTargets(null, null, messageCollector, null, 11, null), null, (int)4, null);
        Thread readErrThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(process, logger){
            final /* synthetic */ Process $process;
            final /* synthetic */ KotlinLogger $logger;

            public final void invoke() {
                InputStream inputStream = this.$process.getErrorStream();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Closeable closeable = inputStream2;
                int n = 0;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                n = 8192;
                boolean bl2 = false;
                TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), (Function1)((Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ runToolInSeparateProcess.readErrThread.1 this$0;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.this$0.$logger.error(it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$process = process;
                this.$logger = kotlinLogger2;
                super(0);
            }
        }), (int)31, null);
        if (logger instanceof GradleKotlinLogger) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            object = inputStream;
            charset = Charsets.UTF_8;
            boolean bl = false;
            Object object2 = object;
            int n = 0;
            object2 = new InputStreamReader((InputStream)object2, charset);
            n = 8192;
            boolean bl2 = false;
            TextStreamsKt.forEachLine((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)), (Function1)((Function1)new Function1<String, Unit>(logger){
                final /* synthetic */ KotlinLogger $logger;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ((GradleKotlinLogger)this.$logger).lifecycle(it);
                }
                {
                    this.$logger = kotlinLogger2;
                    super(1);
                }
            }));
        } else {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            object = inputStream;
            charset = Charsets.UTF_8;
            boolean bl = false;
            Object object3 = object;
            int n = 0;
            object3 = new InputStreamReader((InputStream)object3, charset);
            n = 8192;
            boolean bl3 = false;
            TextStreamsKt.forEachLine((Reader)(object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n)), (Function1)runToolInSeparateProcess.2.INSTANCE);
        }
        readErrThread2.join();
        int exitCode = process.waitFor();
        ReportUtilsKt.logFinish(logger, "out-of-process");
        return ReportUtilsKt.exitCodeFromProcessExitCode(logger, exitCode);
    }

    private static final File writeArgumentsToFile(File directory2, String[] argsArray) {
        File compilerOptions = Files.createTempFile(directory2.toPath(), LocalDateTime.now().format(DateTimeFormatter.BASIC_ISO_DATE) + "_", ".compiler.options", new FileAttribute[0]).toFile();
        compilerOptions.deleteOnExit();
        File file = compilerOptions;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"compilerOptions");
        FilesKt.writeText$default((File)file, (String)ArraysKt.joinToString$default((Object[])argsArray, (CharSequence)" ", null, null, (int)0, null, (Function1)writeArgumentsToFile.1.INSTANCE, (int)30, null), null, (int)2, null);
        return compilerOptions;
    }

    private static final MessageCollector createLoggingMessageCollector(KotlinLogger log) {
        return new MessageCollector(log){
            private boolean hasErrors;
            private final MessageRenderer messageRenderer;
            final /* synthetic */ KotlinLogger $log;

            public void clear() {
                this.hasErrors = false;
            }

            public boolean hasErrors() {
                return this.hasErrors;
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
                Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                String locMessage = this.messageRenderer.render(severity, message2, location);
                switch (ReportUtilsKt$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        String string = locMessage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locMessage");
                        this.$log.error(string);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        String string = locMessage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locMessage");
                        this.$log.info(string);
                        break;
                    }
                    case 6: {
                        String string = locMessage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locMessage");
                        this.$log.debug(string);
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
            }
            {
                this.$log = $captured_local_variable$0;
                this.messageRenderer = MessageRenderer.PLAIN_FULL_PATHS;
            }
        };
    }

    public static final void logFinish(@NotNull KotlinLogger $this$logFinish, @NotNull String strategy) {
        Intrinsics.checkParameterIsNotNull((Object)$this$logFinish, (String)"$this$logFinish");
        Intrinsics.checkParameterIsNotNull((Object)strategy, (String)"strategy");
        $this$logFinish.debug("Finished executing kotlin compiler using " + strategy + " strategy");
    }

    @NotNull
    public static final ExitCode exitCodeFromProcessExitCode(@NotNull KotlinLogger log, int code) {
        ExitCode exitCode;
        block2: {
            ExitCode exitCode2;
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            ExitCode[] exitCodeArray = ExitCode.values();
            boolean bl = false;
            ExitCode[] exitCodeArray2 = exitCodeArray;
            boolean bl2 = false;
            ExitCode[] exitCodeArray3 = exitCodeArray2;
            int n = exitCodeArray3.length;
            for (int j = 0; j < n; ++j) {
                ExitCode exitCode3;
                ExitCode it = exitCode3 = exitCodeArray3[j];
                boolean bl3 = false;
                if (!(it.getCode() == code)) continue;
                exitCode2 = exitCode3;
                break block2;
            }
            exitCode2 = exitCode = null;
        }
        if (exitCode != null) {
            return exitCode;
        }
        log.debug("Could not find exit code by value: " + code);
        return code == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
    }
}

