/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0080\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0080\b\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a.\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004H\u0080\b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"kotlinDebug", "", "Lorg/gradle/api/logging/Logger;", "message", "Lkotlin/Function0;", "", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "fn", "kotlinInfo", "kotlinWarn", "logTime", "T", "action", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin"})
public final class GradleLoggingUtilsKt {
    public static final void kotlinInfo(@NotNull Logger $this$kotlinInfo, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$kotlinInfo, (String)"$this$kotlinInfo");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        $this$kotlinInfo.info("[KOTLIN] " + message2);
    }

    public static final void kotlinDebug(@NotNull Logger $this$kotlinDebug, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$kotlinDebug, (String)"$this$kotlinDebug");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        $this$kotlinDebug.debug("[KOTLIN] " + message2);
    }

    public static final void kotlinWarn(@NotNull Logger $this$kotlinWarn, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$kotlinWarn, (String)"$this$kotlinWarn");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        $this$kotlinWarn.warn("[KOTLIN] " + message2);
    }

    public static final void kotlinDebug(@NotNull Logger $this$kotlinDebug, @NotNull Function0<String> message2) {
        int $i$f$kotlinDebug = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$kotlinDebug, (String)"$this$kotlinDebug");
        Intrinsics.checkParameterIsNotNull(message2, (String)"message");
        if ($this$kotlinDebug.isDebugEnabled()) {
            GradleLoggingUtilsKt.kotlinDebug($this$kotlinDebug, (String)message2.invoke());
        }
    }

    public static final void kotlinDebug(@NotNull KotlinLogger $this$kotlinDebug, @NotNull Function0<String> fn) {
        int $i$f$kotlinDebug = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$kotlinDebug, (String)"$this$kotlinDebug");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        if ($this$kotlinDebug.isDebugEnabled()) {
            String msg = (String)fn.invoke();
            $this$kotlinDebug.debug("[KOTLIN] " + msg);
        }
    }

    public static final <T> T logTime(@NotNull KotlinLogger $this$logTime, @NotNull String action, @NotNull Function0<? extends T> fn) {
        int $i$f$logTime = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$logTime, (String)"$this$logTime");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        long startNs = System.nanoTime();
        Object result2 = fn.invoke();
        long endNs = System.nanoTime();
        long timeNs = endNs - startNs;
        double timeMs = (double)timeNs / (double)1000000;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s took %.2f ms";
        Object[] objectArray = new Object[]{action, timeMs};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        $this$logTime.debug(string2);
        return (T)result2;
    }
}

