/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandler;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J)\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporterHandler;", "", "()V", "buildFinished", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "perfReportFile", "Ljava/io/File;", "kotlinTaskTimeNs", "", "", "", "allTasksTimeNs", "failure", "", "buildInfo", "taskOverview", "taskOverview$kotlin_gradle_plugin", "TextTable", "kotlin-gradle-plugin"})
public final class KotlinBuildReporterHandler {
    public final void buildFinished(@NotNull Gradle gradle, @NotNull File perfReportFile, @NotNull Map<String, Long> kotlinTaskTimeNs, long allTasksTimeNs, @Nullable Throwable failure) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull((Object)perfReportFile, (String)"perfReportFile");
        Intrinsics.checkParameterIsNotNull(kotlinTaskTimeNs, (String)"kotlinTaskTimeNs");
        Project project = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
        Logger logger = project.getLogger();
        try {
            FilesKt.writeText$default((File)perfReportFile, (String)(this.buildInfo(gradle, failure) + this.taskOverview$kotlin_gradle_plugin(kotlinTaskTimeNs, allTasksTimeNs)), null, (int)2, null);
            logger.lifecycle("Kotlin build report is written to " + perfReportFile.getCanonicalPath());
        }
        catch (Throwable e) {
            logger.error("Could not write Kotlin build report to " + perfReportFile.getCanonicalPath(), e);
        }
    }

    public static /* synthetic */ void buildFinished$default(KotlinBuildReporterHandler kotlinBuildReporterHandler, Gradle gradle, File file, Map map, long l, Throwable throwable, int n, Object object) {
        if ((n & 0x10) != 0) {
            throwable = null;
        }
        kotlinBuildReporterHandler.buildFinished(gradle, file, map, l, throwable);
    }

    private final String buildInfo(Gradle gradle, Throwable failure) {
        boolean bl = false;
        ArrayList<String> startParams = new ArrayList<String>();
        StartParameter startParameter = gradle.getStartParameter();
        boolean bl2 = false;
        boolean bl3 = false;
        StartParameter $this$apply = startParameter;
        boolean bl4 = false;
        StringBuilder stringBuilder = new StringBuilder().append("tasks = ");
        List list2 = $this$apply.getTaskRequests();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"taskRequests");
        startParams.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)buildInfo.1.1.INSTANCE, (int)31, null)).toString());
        startParams.add("excluded tasks = " + $this$apply.getExcludedTaskNames());
        startParams.add("current dir = " + $this$apply.getCurrentDir());
        startParams.add("project properties args = " + $this$apply.getProjectProperties());
        startParams.add("system properties args = " + $this$apply.getSystemPropertiesArgs());
        boolean bl5 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        bl3 = false;
        boolean bl6 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl7 = false;
        StringBuilder stringBuilder3 = $this$buildString;
        String string = "Gradle start parameters:";
        boolean bl8 = false;
        StringBuilder stringBuilder4 = stringBuilder3.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        Iterable $this$forEach$iv = startParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl9 = false;
            StringBuilder stringBuilder5 = $this$buildString;
            String string2 = "  " + it;
            boolean bl10 = false;
            StringBuilder stringBuilder6 = stringBuilder5.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        if (failure != null) {
            stringBuilder3 = $this$buildString;
            String string3 = "Build failed: " + failure;
            boolean bl11 = false;
            StringBuilder stringBuilder7 = stringBuilder3.append(string3);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        String string4 = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String taskOverview$kotlin_gradle_plugin(@NotNull Map<String, Long> kotlinTaskTimeNs, long allTasksTimeNs) {
        void $this$forEach$iv;
        Iterable $this$sortedByDescending$iv;
        Intrinsics.checkParameterIsNotNull(kotlinTaskTimeNs, (String)"kotlinTaskTimeNs");
        if (kotlinTaskTimeNs.isEmpty()) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl4 = false;
            StringBuilder stringBuilder2 = $this$buildString;
            String string = "No Kotlin task was run";
            boolean bl5 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            String string2 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }
        StringBuilder sb = new StringBuilder();
        long kotlinTotalTimeNs = CollectionsKt.sumOfLong((Iterable)kotlinTaskTimeNs.values());
        String ktTaskPercent = KotlinBuildReporterHandlerKt.asString((double)kotlinTotalTimeNs / (double)allTasksTimeNs * (double)100, 1);
        StringBuilder $this$buildString = sb;
        Object bl4 = "Total time for Kotlin tasks: " + KotlinBuildReporterHandlerKt.formatTime(kotlinTotalTimeNs) + " (" + ktTaskPercent + " % of all tasks time)";
        boolean bl = false;
        StringBuilder stringBuilder = $this$buildString.append((String)bl4);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        TextTable table = new TextTable("Time", "% of Kotlin time", "Task");
        bl4 = kotlinTaskTimeNs.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterator iterator = $this$sortedByDescending$iv;
        boolean bl6 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry $dstr$_u24__u24$timeNs = (Map.Entry)b;
                boolean bl2 = false;
                Map.Entry entry = $dstr$_u24__u24$timeNs;
                boolean bl3 = false;
                long timeNs = ((Number)entry.getValue()).longValue();
                $dstr$_u24__u24$timeNs = (Map.Entry)a;
                Comparable comparable = Long.valueOf(timeNs);
                bl2 = false;
                entry = $dstr$_u24__u24$timeNs;
                bl3 = false;
                timeNs = ((Number)entry.getValue()).longValue();
                Long l = timeNs;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)comparator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void taskPath;
            Map.Entry $dstr$taskPath$timeNs = (Map.Entry)element$iv;
            boolean bl7 = false;
            Map.Entry entry = $dstr$taskPath$timeNs;
            boolean bl8 = false;
            String string = (String)entry.getKey();
            entry = $dstr$taskPath$timeNs;
            bl8 = false;
            long timeNs = ((Number)entry.getValue()).longValue();
            String percent = KotlinBuildReporterHandlerKt.asString((double)timeNs / (double)kotlinTotalTimeNs * (double)100, 1);
            table.addRow(new String[]{KotlinBuildReporterHandlerKt.formatTime(timeNs), percent + " %", taskPath});
        }
        table.printTo(sb);
        StringsKt.appendln((StringBuilder)sb);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporterHandler$TextTable;", "", "columnNames", "", "", "([Ljava/lang/String;)V", "columnsCount", "", "maxLengths", "", "rows", "Ljava/util/ArrayList;", "", "addRow", "", "row", "printTo", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "kotlin-gradle-plugin"})
    public static final class TextTable {
        private final ArrayList<List<String>> rows;
        private final int columnsCount;
        private final int[] maxLengths;

        /*
         * WARNING - void declaration
         */
        public final void addRow(String ... row) {
            Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
            int n = row.length == this.columnsCount ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (n == 0) {
                boolean bl3 = false;
                String string = "Row size " + row.length + " differs from columns count " + this.columnsCount;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.rows.add(ArraysKt.toList((Object[])row));
            String[] stringArray = row;
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                void i2;
                String col = stringArray[n];
                int n3 = this.maxLengths[i2];
                int n4 = col.length();
                boolean bl4 = false;
                this.maxLengths[i2] = Math.max(n3, n4);
                ++i2;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void printTo(@NotNull StringBuilder sb) {
            Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
            for (List<String> row : this.rows) {
                StringsKt.appendln((StringBuilder)sb);
                boolean bl = false;
                List<String> list2 = row;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"row");
                for (String col : (Iterable)list2) {
                    void i2;
                    if (i2 > 0) {
                        sb.append("|");
                    }
                    sb.append(StringsKt.padEnd((String)col, (int)this.maxLengths[i2], (char)' '));
                    ++i2;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public TextTable(String ... columnNames) {
            int[] nArray;
            Intrinsics.checkParameterIsNotNull((Object)columnNames, (String)"columnNames");
            this.rows = new ArrayList();
            int n = this.columnsCount = columnNames.length;
            TextTable textTable = this;
            int[] nArray2 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n2;
                int n5 = n2++;
                nArray = nArray2;
                boolean bl = false;
                nArray[n5] = n3 = columnNames[it].length();
            }
            nArray = nArray2;
            textTable.maxLengths = nArray;
            this.rows.add(ArraysKt.toList((Object[])columnNames));
        }
    }
}

