/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.BuildSession;
import org.jetbrains.kotlin.statistics.fileloggers.FileRecordLogger;
import org.jetbrains.kotlin.statistics.fileloggers.IRecordLogger;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;
import org.jetbrains.kotlin.statistics.fileloggers.NullRecordLogger;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\b\u0010\"\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020$2\u0006\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u0018H\u0016J\u001d\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0015H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;", "Lorg/jetbrains/kotlin/statistics/metrics/IStatisticsValuesConsumer;", "rootPath", "Ljava/io/File;", "maxProfileFiles", "", "maxFileSize", "", "maxFileAge", "(Ljava/io/File;IJJ)V", "buildSession", "Lorg/jetbrains/kotlin/statistics/BuildSession;", "metricsContainer", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "profileFileNameFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "statisticsFolder", "trackingFile", "Lorg/jetbrains/kotlin/statistics/fileloggers/IRecordLogger;", "closeTrackingFile", "", "finishBuildSession", "action", "", "failure", "", "initTrackingFile", "isBuildSessionStarted", "", "report", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "value", "subprojectName", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "startBuildSession", "buildSinceDaemonStart", "buildStartedTime", "(JLjava/lang/Long;)V", "unlockJournalFile", "Companion", "kotlin-gradle-statistics"})
public final class BuildSessionLogger
implements IStatisticsValuesConsumer {
    private final DateTimeFormatter profileFileNameFormatter;
    private final File statisticsFolder;
    private BuildSession buildSession;
    private IRecordLogger trackingFile;
    private final MetricsContainer metricsContainer;
    private final int maxProfileFiles;
    private final long maxFileSize;
    private final long maxFileAge;
    @NotNull
    public static final String STATISTICS_FOLDER_NAME = "kotlin-profile";
    @NotNull
    public static final String STATISTICS_FILE_NAME_PATTERN = "\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{3}.profile";
    private static final int DEFAULT_MAX_PROFILE_FILES = 1000;
    private static final long DEFAULT_MAX_PROFILE_FILE_SIZE = 100000L;
    private static final long DEFAULT_MAX_FILE_AGE = 2592000000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final synchronized void startBuildSession(long buildSinceDaemonStart, @Nullable Long buildStartedTime) {
        IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.GRADLE_BUILD_NUMBER_IN_CURRENT_DAEMON, buildSinceDaemonStart, null, 4, null);
        this.buildSession = new BuildSession(buildStartedTime);
        this.initTrackingFile();
    }

    public final synchronized boolean isBuildSessionStarted() {
        return this.buildSession != null;
    }

    private final synchronized void closeTrackingFile() {
        block0: {
            IRecordLogger iRecordLogger = this.trackingFile;
            if (iRecordLogger == null) break block0;
            IRecordLogger iRecordLogger2 = iRecordLogger;
            boolean bl = false;
            boolean bl2 = false;
            IRecordLogger it = iRecordLogger2;
            boolean bl3 = false;
            this.metricsContainer.flush(it);
            it.close();
            this.trackingFile = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void initTrackingFile() {
        Object object;
        BuildSessionLogger buildSessionLogger;
        this.closeTrackingFile();
        List list2 = Companion.listProfileFiles(this.statisticsFolder);
        if (list2 == null) {
            if (this.statisticsFolder.mkdirs()) {
                list2 = CollectionsKt.emptyList();
            } else {
                return;
            }
        }
        List fileCandidates = list2;
        boolean bl = false;
        for (File file : (Iterable)fileCandidates) {
            long lastModified;
            boolean toDelete;
            void index;
            boolean bl2 = index < fileCandidates.size() - this.maxProfileFiles ? true : (toDelete = (lastModified = file.lastModified()) > 0L && System.currentTimeMillis() - this.maxFileAge > lastModified);
            if (toDelete) {
                file.delete();
            }
            ++index;
        }
        List<File> list3 = Companion.listProfileFiles(this.statisticsFolder);
        if ((list3 != null ? list3.size() : 0) > this.maxProfileFiles * 2) {
            this.trackingFile = new NullRecordLogger();
            return;
        }
        Function0<File> $fun$newFile$1 = new Function0<File>(this){
            final /* synthetic */ BuildSessionLogger this$0;

            @NotNull
            public final File invoke() {
                return new File(BuildSessionLogger.access$getStatisticsFolder$p(this.this$0), BuildSessionLogger.access$getProfileFileNameFormatter$p(this.this$0).format(LocalDateTime.now()));
            }
            {
                this.this$0 = buildSessionLogger;
                super(0);
            }
        };
        Object object2 = (File)CollectionsKt.lastOrNull((List)fileCandidates);
        if (object2 == null) {
            object2 = $fun$newFile$1.invoke();
        }
        File lastFile = object2;
        BuildSessionLogger buildSessionLogger2 = this;
        try {
            buildSessionLogger = buildSessionLogger2;
            object = lastFile.length() < this.maxFileSize ? new FileRecordLogger(lastFile) : new FileRecordLogger((File)$fun$newFile$1.invoke());
        }
        catch (IOException toDelete) {
            IRecordLogger iRecordLogger;
            try {
                buildSessionLogger = buildSessionLogger2;
                iRecordLogger = new FileRecordLogger((File)$fun$newFile$1.invoke());
            }
            catch (IOException iOException) {
                buildSessionLogger = buildSessionLogger2;
                iRecordLogger = new NullRecordLogger();
            }
            object = iRecordLogger;
        }
        buildSessionLogger.trackingFile = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void finishBuildSession(@Nullable String action, @Nullable Throwable failure) {
        try {
            long finishTime = System.currentTimeMillis();
            BuildSession buildSession = this.buildSession;
            if (buildSession != null) {
                BuildSession buildSession2 = buildSession;
                boolean bl = false;
                boolean bl2 = false;
                BuildSession it = buildSession2;
                boolean bl3 = false;
                if (it.getBuildStartedTime() != null) {
                    IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.GRADLE_BUILD_DURATION, finishTime - it.getBuildStartedTime(), null, 4, null);
                }
                IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.GRADLE_EXECUTION_DURATION, finishTime - it.getProjectEvaluatedTime(), null, 4, null);
                IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, NumericalMetrics.BUILD_FINISH_TIME, finishTime, null, 4, null);
                IStatisticsValuesConsumer.DefaultImpls.report$default((IStatisticsValuesConsumer)this, BooleanMetrics.BUILD_FAILED, failure != null, null, 4, null);
            }
            this.buildSession = null;
        }
        finally {
            this.unlockJournalFile();
        }
    }

    private final synchronized void unlockJournalFile() {
        this.closeTrackingFile();
    }

    @Override
    public void report(@NotNull BooleanMetrics metric, boolean value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        this.metricsContainer.report(metric, value, subprojectName);
    }

    @Override
    public void report(@NotNull NumericalMetrics metric, long value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        this.metricsContainer.report(metric, value, subprojectName);
    }

    @Override
    public void report(@NotNull StringMetrics metric, @NotNull String value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.metricsContainer.report(metric, value, subprojectName);
    }

    /*
     * WARNING - void declaration
     */
    public BuildSessionLogger(@NotNull File rootPath, int maxProfileFiles, long maxFileSize, long maxFileAge) {
        void it;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.maxProfileFiles = maxProfileFiles;
        this.maxFileSize = maxFileSize;
        this.maxFileAge = maxFileAge;
        this.profileFileNameFormatter = DateTimeFormatter.ofPattern("YYYY-MM-dd-HH-mm-ss-SSS'.profile'");
        File file = new File(rootPath, STATISTICS_FOLDER_NAME);
        boolean bl = false;
        boolean bl2 = false;
        File file2 = file;
        BuildSessionLogger buildSessionLogger = this;
        boolean bl3 = false;
        it.mkdirs();
        Unit unit = Unit.INSTANCE;
        buildSessionLogger.statisticsFolder = file;
        this.metricsContainer = new MetricsContainer();
    }

    public /* synthetic */ BuildSessionLogger(File file, int n, long l, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        if ((n2 & 4) != 0) {
            l = 100000L;
        }
        if ((n2 & 8) != 0) {
            l2 = 2592000000L;
        }
        this(file, n, l, l2);
    }

    public static final /* synthetic */ File access$getStatisticsFolder$p(BuildSessionLogger $this) {
        return $this.statisticsFolder;
    }

    public static final /* synthetic */ DateTimeFormatter access$getProfileFileNameFormatter$p(BuildSessionLogger $this) {
        return $this.profileFileNameFormatter;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion;", "", "()V", "DEFAULT_MAX_FILE_AGE", "", "DEFAULT_MAX_PROFILE_FILES", "", "DEFAULT_MAX_PROFILE_FILE_SIZE", "STATISTICS_FILE_NAME_PATTERN", "", "STATISTICS_FOLDER_NAME", "listProfileFiles", "", "Ljava/io/File;", "statisticsFolder", "kotlin-gradle-statistics"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<File> listProfileFiles(@NotNull File statisticsFolder) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
            File[] fileArray = statisticsFolder.listFiles();
            if (fileArray != null) {
                void var3_3;
                void $this$filterTo$iv;
                File[] fileArray2 = fileArray;
                Collection destination$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var5_5 = $this$filterTo$iv;
                int n = ((void)var5_5).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void it = element$iv = var5_5[j];
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    String string = v1.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    CharSequence charSequence = string;
                    String string2 = BuildSessionLogger.STATISTICS_FILE_NAME_PATTERN;
                    boolean bl2 = false;
                    string2 = new Regex(string2);
                    bl2 = false;
                    if (!string2.matches(charSequence)) continue;
                    destination$iv.add(element$iv);
                }
                list2 = CollectionsKt.sorted((Iterable)((ArrayList)var3_3));
            } else {
                list2 = null;
            }
            return list2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

