/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.gradle.report.TextTable;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.report.data.TaskExecutionData;
import org.jetbrains.kotlin.gradle.utils.Printer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "outputFile", "Ljava/io/File;", "printMetrics", "", "log", "Lorg/gradle/api/logging/Logger;", "(Ljava/io/File;ZLorg/gradle/api/logging/Logger;)V", "p", "Lorg/jetbrains/kotlin/gradle/utils/Printer;", "printBuildAttributes", "", "buildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "printBuildInfo", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "printBuildReport", "printBuildTimes", "buildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "printTaskLog", "task", "Lorg/jetbrains/kotlin/gradle/report/data/TaskExecutionData;", "printTaskOverview", "printTasksLog", "process", "kotlin-gradle-plugin"})
public final class PlainTextBuildReportWriter
implements BuildExecutionDataProcessor {
    @NotNull
    private final File outputFile;
    private final boolean printMetrics;
    @NotNull
    private final Logger log;
    private Printer p;

    public PlainTextBuildReportWriter(@NotNull File outputFile2, boolean printMetrics, @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile2, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.outputFile = outputFile2;
        this.printMetrics = printMetrics;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull BuildExecutionData build2) {
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        try {
            Object object = this.outputFile;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileOutputStream((File)object3);
            bl3 = false;
            object2 = new OutputStreamWriter((OutputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl5 = false;
                this.p = new Printer(writer, null, null, 6, null);
                this.printBuildReport(build2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            this.log.lifecycle(Intrinsics.stringPlus((String)"Kotlin build report is written to ", (Object)this.outputFile.getCanonicalPath()));
        }
        catch (Exception e) {
            this.log.error(Intrinsics.stringPlus((String)"Could not write Kotlin build report to ", (Object)this.outputFile.getCanonicalPath()), (Throwable)e);
        }
    }

    private final void printBuildReport(BuildExecutionData build2) {
        this.printBuildInfo(build2);
        this.printMetrics(build2.getAggregatedMetrics());
        this.printTaskOverview(build2);
        this.printTasksLog(build2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildExecutionData build2) {
        void this_$iv;
        Object object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = build2.getStartParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                String[] stringArray2 = this.p;
                if (stringArray2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    throw null;
                }
                String[] stringArray3 = stringArray2;
                stringArray2 = new String[]{it};
                stringArray3.println(stringArray2);
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        object.println(new String[0]);
        if (build2.getFailure() != null) {
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                throw null;
            }
            String[] stringArray4 = object;
            object = new String[]{Intrinsics.stringPlus((String)"Build failed: ", (Object)build2.getFailure())};
            stringArray4.println((String)object);
        }
        if ((object = this.p) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        object.println(new String[0]);
    }

    private final void printMetrics(BuildMetrics buildMetrics) {
        if (!this.printMetrics) {
            return;
        }
        this.printBuildTimes(buildMetrics.getBuildTimes());
        this.printBuildAttributes(buildMetrics.getBuildAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildTimes(BuildTimes buildTimes) {
        void this_$iv;
        Map collectedBuildTimes = buildTimes.asMap();
        if (collectedBuildTimes.isEmpty()) {
            return;
        }
        Object object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        String[] stringArray = object;
        object = new String[]{"Time metrics:"};
        stringArray.println((String[])object);
        object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet<BuildTime> visitedBuildTimes = new HashSet<BuildTime>();
            for (BuildTime buildTime : BuildTime.values()) {
                if (buildTime.getParent() != null) continue;
                PlainTextBuildReportWriter.printBuildTimes$lambda-5$printBuildTime(visitedBuildTimes, collectedBuildTimes, this, buildTime);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        ((Printer)object).println(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(BuildAttributes buildAttributes) {
        void this_$iv;
        Map allAttributes = buildAttributes.asMap();
        if (allAttributes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            void $this$groupByTo$iv$iv2;
            boolean bl = false;
            Iterable $this$groupBy$iv = allAttributes.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap((Map)destination$iv$iv);
            Object object = attributesByKind;
            boolean $this$groupByTo$iv$iv2 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv$iv;
                destination$iv$iv = object = iterator.next();
                $i$f$groupByTo2 = false;
                BuildAttributeKind kind = (BuildAttributeKind)destination$iv$iv.getKey();
                Object $i$f$groupByTo2 = object;
                boolean bl4 = false;
                List attributesCounts = (List)$i$f$groupByTo2.getValue();
                $i$f$groupByTo2 = this.p;
                if ($i$f$groupByTo2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    throw null;
                }
                Object object2 = $i$f$groupByTo2;
                String string = kind.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)attributesCounts, (String)"attributesCounts");
                $i$f$groupByTo2 = attributesCounts;
                String string2 = string;
                Object object3 = object2;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $dstr$k$v;
                    Map.Entry $i$f$getOrPut = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    void answer$iv$iv$iv = $dstr$k$v;
                    boolean bl6 = false;
                    BuildAttribute k = (BuildAttribute)answer$iv$iv$iv.getKey();
                    void var26_36 = $dstr$k$v;
                    boolean bl7 = false;
                    int v = ((Number)var26_36.getValue()).intValue();
                    Pair pair = TuplesKt.to((Object)k.name(), (Object)v);
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv2;
                PlainTextBuildReportWriterKt.access$printMap((Printer)object3, string2, MapsKt.toMap((Iterable)collection));
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        printer.println(new String[0]);
    }

    private final void printTaskOverview(BuildExecutionData build2) {
        long allTasksTimeNs = 0L;
        long kotlinTotalTimeNs = 0L;
        ArrayList<TaskExecutionData> kotlinTasks = new ArrayList<TaskExecutionData>();
        for (TaskExecutionData taskExecutionData : build2.getTaskExecutionData()) {
            long taskTimeNs = taskExecutionData.getTotalTimeNs();
            allTasksTimeNs += taskTimeNs;
            if (!taskExecutionData.isKotlinTask()) continue;
            kotlinTotalTimeNs += taskTimeNs;
            kotlinTasks.add(taskExecutionData);
        }
        if (kotlinTasks.isEmpty()) {
            Object object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                throw null;
            }
            String[] stringArray = object;
            object = new String[]{"No Kotlin task was run"};
            stringArray.println((String)object);
            return;
        }
        String ktTaskPercent = KotlinBuildReporterHandlerKt.asString((double)kotlinTotalTimeNs / (double)allTasksTimeNs * (double)100, 1);
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        String[] stringArray = new String[]{"Total time for Kotlin tasks: " + KotlinBuildReporterHandlerKt.formatTime(kotlinTotalTimeNs) + " (" + ktTaskPercent + " % of all tasks time)"};
        printer.println(stringArray);
        Object object = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable textTable = new TextTable((String[])object);
        Iterable $this$sortedByDescending$iv = kotlinTasks;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        String[] stringArray2 = (String[])new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskExecutionData it = (TaskExecutionData)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalTimeNs());
                it = (TaskExecutionData)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalTimeNs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        for (TaskExecutionData task3 : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)stringArray2)) {
            long timeNs = task3.getTotalTimeNs();
            String percent = KotlinBuildReporterHandlerKt.asString((double)timeNs / (double)kotlinTotalTimeNs * (double)100, 1);
            stringArray2 = new String[3];
            stringArray2[0] = KotlinBuildReporterHandlerKt.formatTime(timeNs);
            stringArray2[1] = Intrinsics.stringPlus((String)percent, (Object)" %");
            String string = task3.getTask().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.task.path");
            stringArray2[2] = string;
            textTable.addRow(stringArray2);
        }
        object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        textTable.printTo((Printer)object);
        object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        ((Printer)object).println(new String[0]);
    }

    private final void printTasksLog(BuildExecutionData build2) {
        for (TaskExecutionData task : build2.getTaskExecutionData()) {
            this.printTaskLog(task);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                throw null;
            }
            printer.println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(TaskExecutionData task) {
        Object object;
        String skipMessage = task.getResultState().getSkipMessage();
        if (skipMessage != null) {
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                throw null;
            }
            String[] stringArray = object;
            object = new String[]{task + " was skipped: " + skipMessage};
            stringArray.println((String[])object);
        } else {
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                throw null;
            }
            String[] stringArray = object;
            object = new String[]{task + " finished in " + KotlinBuildReporterHandlerKt.formatTime(task.getTotalTimeNs())};
            stringArray.println((String[])object);
        }
        object = task.getIcLogLines();
        boolean bl = false;
        if (!object.isEmpty()) {
            void this_$iv;
            String[] stringArray;
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                throw null;
            }
            String headLine$iv = "Compilation log for " + task + ':';
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                stringArray = new String[]{headLine$iv};
                this_$iv.println(stringArray);
            }
            this_$iv.pushIndent();
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = task.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    String[] stringArray2 = this.p;
                    if (stringArray2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                        throw null;
                    }
                    String[] stringArray3 = stringArray2;
                    stringArray2 = new String[]{it};
                    stringArray3.println(stringArray2);
                }
                stringArray = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        this.printMetrics(task.getBuildMetrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void printBuildTimes$lambda-5$printBuildTime(HashSet<BuildTime> $visitedBuildTimes, Map<BuildTime, Long> $collectedBuildTimes, PlainTextBuildReportWriter this$0, BuildTime buildTime) {
        if (!$visitedBuildTimes.add(buildTime)) {
            return;
        }
        Object object = $collectedBuildTimes.get(buildTime);
        if (object == null) {
            return;
        }
        long timeNs = (Long)object;
        object = this$0.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        String[] stringArray = object;
        object = new String[]{buildTime.name() + ": " + KotlinBuildReporterHandlerKt.formatTime(timeNs)};
        stringArray.println((String[])object);
        object = this$0.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            throw null;
        }
        Object this_$iv = object;
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        ((Printer)this_$iv).pushIndent();
        try {
            Unit unit;
            boolean bl = false;
            List list2 = (List)BuildTime.Companion.getChildren().get(buildTime);
            if (list2 == null) {
                unit = null;
            } else {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BuildTime it = (BuildTime)element$iv;
                    boolean bl2 = false;
                    PlainTextBuildReportWriter.printBuildTimes$lambda-5$printBuildTime($visitedBuildTimes, $collectedBuildTimes, this$0, it);
                }
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        finally {
            ((Printer)this_$iv).popIndent();
        }
    }
}

