/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.internal;

import java.io.File;
import java.io.FilterReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.stream.JsonReader;
import org.jetbrains.kotlin.com.google.gson.stream.JsonToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;
import org.jetbrains.kotlin.com.google.gson.stream.MalformedJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\nH\u0016J \u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\"H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0018H\u0014J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0018H\u0014J\u0018\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0018H\u0002J$\u0010/\u001a\u00020\"2\n\u00100\u001a\u000601j\u0002`22\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0018H\u0002J\u001c\u0010/\u001a\u00020\"2\n\u00100\u001a\u000601j\u0002`22\u0006\u0010.\u001a\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/internal/RewriteSourceMapFilterReader;", "Ljava/io/FilterReader;", "input", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "buffer", "Ljava/lang/StringBuffer;", "getBuffer", "()Ljava/lang/StringBuffer;", "bufferAvailable", "", "getBufferAvailable", "()I", "bufferJsonWriter", "Lorg/jetbrains/kotlin/com/google/gson/stream/JsonWriter;", "bufferReadPos", "bufferWriter", "Ljava/io/StringWriter;", "getInput", "()Ljava/io/Reader;", "inputEof", "", "prologLimit", "srcSourceRoot", "", "getSrcSourceRoot", "()Ljava/lang/String;", "setSrcSourceRoot", "(Ljava/lang/String;)V", "targetSourceRoot", "getTargetSourceRoot", "setTargetSourceRoot", "wasReadFirst", "maybeReadFirst", "", "read", "dest", "", "initialDestOffset", "n", "readFirst", "skip", "", "transformString", "value", "warnUnsupported", "reason", "writeBackUnsupported", "jsonString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "reader", "Lorg/jetbrains/kotlin/com/google/gson/stream/JsonReader;", "message", "Companion", "kotlin-gradle-plugin"})
public class RewriteSourceMapFilterReader
extends FilterReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Reader input;
    private boolean wasReadFirst;
    private final int prologLimit = 1048575;
    private StringWriter bufferWriter;
    private JsonWriter bufferJsonWriter;
    private int bufferReadPos;
    private boolean inputEof;
    public String srcSourceRoot;
    public String targetSourceRoot;
    @NotNull
    public static final String PROLOG_END = "],\"sourcesContent\":";
    @NotNull
    public static final String UNSUPPORTED_FORMAT_MESSAGE = "Unsupported format. Contents should starts with `{\"version\":3,\"file\":\"...\",\"sources\":[...],\"sourcesContent\":...`";
    private static final Logger log = LoggerFactory.getLogger((String)"kotlin");

    public RewriteSourceMapFilterReader(@NotNull Reader input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        super(input);
        this.input = input;
        this.prologLimit = 1048575;
    }

    @NotNull
    public final Reader getInput() {
        return this.input;
    }

    private final StringBuffer getBuffer() {
        StringWriter stringWriter = this.bufferWriter;
        if (stringWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferWriter");
            throw null;
        }
        StringBuffer stringBuffer = stringWriter.getBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuffer, (String)"bufferWriter.buffer");
        return stringBuffer;
    }

    private final int getBufferAvailable() {
        return this.getBuffer().length() - this.bufferReadPos;
    }

    @NotNull
    public final String getSrcSourceRoot() {
        String string = this.srcSourceRoot;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"srcSourceRoot");
        throw null;
    }

    public final void setSrcSourceRoot(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.srcSourceRoot = string;
    }

    @NotNull
    public final String getTargetSourceRoot() {
        String string = this.targetSourceRoot;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"targetSourceRoot");
        throw null;
    }

    public final void setTargetSourceRoot(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.targetSourceRoot = string;
    }

    private final void maybeReadFirst() {
        if (!this.wasReadFirst) {
            this.wasReadFirst = true;
            this.readFirst();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void readFirst() {
        int jsonPrologPos;
        StringBuilder jsonString;
        block32: {
            jsonString = new StringBuilder();
            char[] readBuffer = new char[1024];
            int lastRead = 0;
            jsonPrologPos = 0;
            do {
                if ((lastRead = this.input.read(readBuffer)) == -1) {
                    this.inputEof = true;
                    this.writeBackUnsupported(jsonString, "Unsupported format. Contents should starts with `{\"version\":3,\"file\":\"...\",\"sources\":[...],\"sourcesContent\":...`. \"sourcesContent\" or \"sources\" not found");
                    return;
                }
                int prevEnd = jsonString.length();
                jsonString.append(readBuffer, 0, lastRead);
                jsonPrologPos = jsonString.indexOf(PROLOG_END, prevEnd - PROLOG_END.length());
                if (jsonPrologPos != -1) break block32;
            } while (jsonString.length() + lastRead <= this.prologLimit);
            this.writeBackUnsupported(jsonString, "Too many sources or format is not supported");
            return;
        }
        this.bufferWriter = new StringWriter(jsonString.length());
        StringWriter prevEnd = this.bufferWriter;
        if (prevEnd == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferWriter");
            throw null;
        }
        this.bufferJsonWriter = new JsonWriter(prevEnd);
        JsonReader json = new JsonReader(new StringReader(jsonString.toString()));
        try {
            Object token;
            json.beginObject();
            JsonWriter jsonWriter = this.bufferJsonWriter;
            if (jsonWriter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bufferJsonWriter");
                throw null;
            }
            jsonWriter.beginObject();
            block16: while (true) {
                boolean bl = (token = json.peek()) == JsonToken.NAME;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "JSON key expected, but " + token + " found";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String key = json.nextName();
                String string = key;
                if (string == null) throw new IllegalStateException("Unknown key \"" + key + '\"');
                int n = -1;
                switch (string.hashCode()) {
                    case 3143036: {
                        if (string.equals("file")) {
                            n = 1;
                        }
                        break;
                    }
                    case -2021876808: {
                        if (string.equals("sources")) {
                            n = 2;
                        }
                        break;
                    }
                    case -252243551: {
                        if (string.equals("sourcesContent")) {
                            n = 3;
                        }
                        break;
                    }
                    case 351608024: {
                        if (string.equals("version")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        json.beginArray();
                        JsonWriter jsonWriter2 = this.bufferJsonWriter;
                        if (jsonWriter2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferJsonWriter");
                            throw null;
                        }
                        jsonWriter2.name("sources").beginArray();
                        while (json.peek() != JsonToken.END_ARRAY) {
                            String path = json.nextString();
                            JsonWriter jsonWriter3 = this.bufferJsonWriter;
                            if (jsonWriter3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"bufferJsonWriter");
                                throw null;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"path");
                            jsonWriter3.value(this.transformString(path));
                        }
                        json.endArray();
                        continue block16;
                    }
                    case 4: {
                        JsonWriter jsonWriter2 = this.bufferJsonWriter;
                        if (jsonWriter2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferJsonWriter");
                            throw null;
                        }
                        jsonWriter2.name(key).value((Number)json.nextInt());
                        continue block16;
                    }
                    case 1: {
                        JsonWriter jsonWriter2 = this.bufferJsonWriter;
                        if (jsonWriter2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferJsonWriter");
                            throw null;
                        }
                        jsonWriter2.name(key).value(json.nextString());
                        continue block16;
                    }
                    case 3: {
                        break block16;
                    }
                    default: {
                        throw new IllegalStateException("Unknown key \"" + key + '\"');
                    }
                }
                break;
            }
            token = this.bufferWriter;
            if (token == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bufferWriter");
                throw null;
            }
            ((StringWriter)token).append(jsonString.substring(jsonPrologPos));
            return;
        }
        catch (IllegalStateException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.writeBackUnsupported(jsonString, json, string);
            return;
        }
        catch (MalformedJsonException e) {
            this.writeBackUnsupported(jsonString, json, "Malformed JSON");
        }
    }

    private final void writeBackUnsupported(StringBuilder jsonString, JsonReader reader, String message2) {
        StringBuilder stringBuilder = new StringBuilder().append("Unsupported format. Contents should starts with `{\"version\":3,\"file\":\"...\",\"sources\":[...],\"sourcesContent\":...`. ").append(message2).append(" at ");
        String string = reader.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.toString()");
        this.writeBackUnsupported(jsonString, stringBuilder.append(StringsKt.replace$default((String)string, (String)"JsonReader at ", (String)"", (boolean)false, (int)4, null)).append(" in `").append((Object)jsonString).toString());
    }

    private final void writeBackUnsupported(StringBuilder jsonString, String reason) {
        String string = jsonString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString.toString()");
        this.writeBackUnsupported(string, reason);
    }

    private final void writeBackUnsupported(String jsonString, String reason) {
        this.warnUnsupported(reason);
        StringWriter stringWriter = this.bufferWriter = new StringWriter(jsonString.length());
        if (stringWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bufferWriter");
            throw null;
        }
        stringWriter.append(jsonString);
    }

    protected void warnUnsupported(@NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        log.warn(Intrinsics.stringPlus((String)"Cannot rewrite paths in JavaScript source maps: ", (Object)reason));
    }

    @NotNull
    protected String transformString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        File file = FilesKt.resolve((File)new File(this.getSrcSourceRoot()), (String)value).getCanonicalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(srcSourceRoot)\n            .resolve(value)\n            .canonicalFile");
        String string = FilesKt.relativeToOrSelf((File)file, (File)new File(this.getTargetSourceRoot())).getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(srcSourceRoot)\n            .resolve(value)\n            .canonicalFile\n            .relativeToOrSelf(File(targetSourceRoot))\n            .path");
        return string;
    }

    @Override
    public int read() {
        this.maybeReadFirst();
        if (this.getBufferAvailable() == 0) {
            if (this.inputEof) {
                return -1;
            }
            int read = this.input.read();
            if (read == -1) {
                this.inputEof = true;
                return -1;
            }
            return read;
        }
        RewriteSourceMapFilterReader rewriteSourceMapFilterReader = this;
        int n = rewriteSourceMapFilterReader.bufferReadPos;
        rewriteSourceMapFilterReader.bufferReadPos = n + 1;
        return this.getBuffer().charAt(n);
    }

    @Override
    public int read(@NotNull char[] dest, int initialDestOffset, int n) {
        int todo;
        int toRead;
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        this.maybeReadFirst();
        int destOffset = initialDestOffset;
        for (todo = n; todo > 0; todo -= toRead) {
            if (this.getBufferAvailable() == 0) {
                if (this.inputEof) {
                    return n == todo ? -1 : n - todo;
                }
                int read = this.input.read(dest, destOffset, todo);
                if (read == -1) {
                    this.inputEof = true;
                    return n - todo;
                }
                return read + (n - todo);
            }
            int n2 = this.getBufferAvailable();
            boolean bl = false;
            toRead = Math.min(todo, n2);
            this.getBuffer().getChars(this.bufferReadPos, this.bufferReadPos + toRead, dest, destOffset);
            RewriteSourceMapFilterReader rewriteSourceMapFilterReader = this;
            rewriteSourceMapFilterReader.bufferReadPos += toRead;
            destOffset += toRead;
        }
        return n - todo;
    }

    @Override
    public long skip(long n) {
        int todo;
        int toRead;
        this.maybeReadFirst();
        for (todo = (int)n; todo > 0; todo -= toRead) {
            if (this.getBufferAvailable() == 0) {
                if (this.inputEof) {
                    return n - (long)todo;
                }
                long read = this.input.skip(todo);
                if (read == 0L && todo != 0) {
                    this.inputEof = true;
                    return n - (long)todo;
                }
                return read + (n - (long)todo);
            }
            int n2 = this.getBufferAvailable();
            boolean bl = false;
            toRead = Math.min(todo, n2);
            RewriteSourceMapFilterReader rewriteSourceMapFilterReader = this;
            rewriteSourceMapFilterReader.bufferReadPos += toRead;
        }
        return n - (long)todo;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/internal/RewriteSourceMapFilterReader$Companion;", "", "()V", "PROLOG_END", "", "UNSUPPORTED_FORMAT_MESSAGE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

