/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerLogLevel;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.KonanDistribution;
import org.jetbrains.kotlin.commonizer.KonanDistributionKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.NativeDistributionCommonizer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizationCacheKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache;", "Lorg/jetbrains/kotlin/commonizer/NativeDistributionCommonizer;", "project", "Lorg/gradle/api/Project;", "commonizer", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/commonizer/NativeDistributionCommonizer;)V", "canReturnFast", "", "konanHome", "Ljava/io/File;", "missingOutputTargets", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "commonizeNativeDistribution", "", "outputDirectory", "outputTargets", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "logLevel", "Lorg/jetbrains/kotlin/commonizer/CommonizerLogLevel;", "isCached", "directory", "logInfo", "message", "", "Logging", "kotlin-gradle-plugin"})
public final class NativeDistributionCommonizationCache
implements NativeDistributionCommonizer {
    @NotNull
    private final Project project;
    @NotNull
    private final NativeDistributionCommonizer commonizer;

    public NativeDistributionCommonizationCache(@NotNull Project project, @NotNull NativeDistributionCommonizer commonizer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)commonizer, (String)"commonizer");
        this.project = project;
        this.commonizer = commonizer;
    }

    /*
     * WARNING - void declaration
     */
    public void commonizeNativeDistribution(@NotNull File konanHome, @NotNull File outputDirectory, @NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull CommonizerLogLevel logLevel) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$forEach$iv;
        File file;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Set enqueuedOutputTargets;
        void $this$onEach$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Intrinsics.checkParameterIsNotNull((Object)konanHome, (String)"konanHome");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkParameterIsNotNull(outputTargets, (String)"outputTargets");
        Intrinsics.checkParameterIsNotNull((Object)logLevel, (String)"logLevel");
        if (!NativeDistributionCommonizationCacheKt.isNativeDistributionCommonizationCacheEnabled(this.project)) {
            this.logInfo("Cache disabled");
        }
        Iterable iterable = outputTargets;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv2;
        Collection destination$iv$iv322 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!this.isCached(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory, (CommonizerTarget)outputTarget))) continue;
            destination$iv$iv322.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv322;
        boolean $i$f$onEach22 = false;
        $this$filterTo$iv$iv2 = $this$onEach$iv;
        boolean destination$iv$iv322 = false;
        $i$f$filterTo = false;
        void $this$apply$iv = $this$filterTo$iv$iv2;
        boolean $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv22 = false;
        for (Object element$iv : $this$apply$iv) {
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            this.logInfo("Cache hit: " + outputTarget + " already commonized");
        }
        Set cachedOutputTargets = CollectionsKt.toSet((Iterable)$this$filterTo$iv$iv2);
        Set set2 = enqueuedOutputTargets = NativeDistributionCommonizationCacheKt.isNativeDistributionCommonizationCacheEnabled(this.project) ? SetsKt.minus(outputTargets, (Iterable)cachedOutputTargets) : outputTargets;
        if (this.canReturnFast(konanHome, enqueuedOutputTargets)) {
            this.logInfo("All available targets are commonized already - Nothing to do");
            return;
        }
        Iterable $i$f$onEach22 = enqueuedOutputTargets;
        boolean $i$f$map = false;
        void destination$iv$iv322 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv22 = $this$mapTo$iv$iv.iterator();
        while ($i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv22.hasNext()) {
            void outputTarget;
            item$iv$iv = $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv22.next();
            SharedCommonizerTarget element$iv = (SharedCommonizerTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            file = CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory, (CommonizerTarget)outputTarget);
            collection.add(file);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File commonizedDirectory = (File)element$iv;
            boolean bl = false;
            if (!commonizedDirectory.exists()) continue;
            FilesKt.deleteRecursively((File)commonizedDirectory);
        }
        this.commonizer.commonizeNativeDistribution(konanHome, outputDirectory, enqueuedOutputTargets, logLevel);
        $this$forEach$iv = enqueuedOutputTargets;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator bl = $this$mapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            item$iv$iv = bl.next();
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            file = CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory, (CommonizerTarget)outputTarget);
            collection.add(file);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File commonizedDirectory = (File)element$iv$iv;
            boolean bl3 = false;
            if (!commonizedDirectory.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File commonizedDirectory = (File)element$iv;
            boolean bl4 = false;
            FilesKt.resolve((File)commonizedDirectory, (String)".success").createNewFile();
        }
    }

    private final boolean isCached(File directory2) {
        File successMarkerFile = FilesKt.resolve((File)directory2, (String)".success");
        return successMarkerFile.isFile();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canReturnFast(File konanHome, Set<? extends CommonizerTarget> missingOutputTargets) {
        boolean bl;
        block6: {
            Object object;
            KonanTarget target2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            if (missingOutputTargets.isEmpty()) {
                return true;
            }
            Iterable $this$map$iv = CommonizerTargetKt.allLeaves((Iterable)missingOutputTargets);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                object = target2.getKonanTarget();
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void konanTarget2;
                target2 = (KonanTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                object = FilesKt.resolve((File)KonanDistributionKt.getPlatformLibsDir((KonanDistribution)new KonanDistribution(konanHome)), (String)konanTarget2.getName());
                collection.add(object);
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File platformLibsDir = (File)element$iv;
                    boolean bl4 = false;
                    if (!platformLibsDir.exists()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void logInfo(String message2) {
        this.project.getLogger().info(Intrinsics.stringPlus((String)"Native Distribution Commonization: ", (Object)message2));
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache$Logging;", "", "()V", "prefix", "", "kotlin-gradle-plugin"})
    private static final class Logging {
        @Deprecated
        @NotNull
        public static final Logging INSTANCE = new Logging();
        @NotNull
        public static final String prefix = "Native Distribution Commonization";

        private Logging() {
        }
    }
}

