/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.LogType;
import org.jetbrains.kotlin.gradle.internal.TeamCityMessageStackTraceProcessor;
import org.jetbrains.kotlin.gradle.internal.TeamCityServiceMessagesKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u001a\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\u000f\u0010'\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b(R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/TeamCityMessageCommonClient;", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageParserCallback;", "clientType", "Lorg/jetbrains/kotlin/gradle/internal/LogType;", "log", "Lorg/gradle/api/logging/Logger;", "(Lorg/jetbrains/kotlin/gradle/internal/LogType;Lorg/gradle/api/logging/Logger;)V", "afterMessage", "", "getAfterMessage", "()Z", "setAfterMessage", "(Z)V", "getClientType$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/internal/LogType;", "errors", "", "", "getLog$kotlin_gradle_plugin", "()Lorg/gradle/api/logging/Logger;", "progressLogger", "Lorg/gradle/internal/logging/progress/ProgressLogger;", "getProgressLogger", "()Lorg/gradle/internal/logging/progress/ProgressLogger;", "setProgressLogger", "(Lorg/gradle/internal/logging/progress/ProgressLogger;)V", "stackTraceProcessor", "Lorg/jetbrains/kotlin/gradle/internal/TeamCityMessageStackTraceProcessor;", "parseException", "", "e", "Ljava/text/ParseException;", "text", "printMessage", "type", "regularText", "serviceMessage", "message", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessage;", "testFailedMessage", "testFailedMessage$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
public final class TeamCityMessageCommonClient
implements ServiceMessageParserCallback {
    @NotNull
    private final LogType clientType;
    @NotNull
    private final Logger log;
    private boolean afterMessage;
    @Nullable
    private ProgressLogger progressLogger;
    @NotNull
    private final List<String> errors;
    @NotNull
    private final TeamCityMessageStackTraceProcessor stackTraceProcessor;

    public TeamCityMessageCommonClient(@NotNull LogType clientType, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)((Object)clientType), (String)"clientType");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.clientType = clientType;
        this.log = log;
        this.errors = new ArrayList();
        this.stackTraceProcessor = new TeamCityMessageStackTraceProcessor();
    }

    @NotNull
    public final LogType getClientType$kotlin_gradle_plugin() {
        return this.clientType;
    }

    @NotNull
    public final Logger getLog$kotlin_gradle_plugin() {
        return this.log;
    }

    public final boolean getAfterMessage() {
        return this.afterMessage;
    }

    public final void setAfterMessage(boolean bl) {
        this.afterMessage = bl;
    }

    @Nullable
    public final ProgressLogger getProgressLogger() {
        return this.progressLogger;
    }

    public final void setProgressLogger(@Nullable ProgressLogger progressLogger) {
        this.progressLogger = progressLogger;
    }

    @Override
    public void parseException(@NotNull ParseException e, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.log.error("Failed to parse test process messages: \"" + text + '\"', (Throwable)e);
    }

    @Override
    public void serviceMessage(@NotNull ServiceMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ServiceMessage serviceMessage = message2;
        if (serviceMessage instanceof Message) {
            String string = ((Message)message2).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.text");
            this.printMessage(string, LogType.Companion.byValueOrNull(((Message)message2).getAttributes().get("type")));
        }
        this.afterMessage = true;
    }

    @Nullable
    public final String testFailedMessage$kotlin_gradle_plugin() {
        return !((Collection)this.errors).isEmpty() ? CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null;
    }

    private final void printMessage(String text, LogType type) {
        String string = text;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String value = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        ProgressLogger progressLogger = this.progressLogger;
        if (progressLogger != null) {
            progressLogger.progress(value);
        }
        String actualText = this.afterMessage ? (StringsKt.startsWith$default((String)value, (String)"\r\n", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)value, (CharSequence)"\r\n") : StringsKt.removePrefix((String)value, (CharSequence)"\n")) : value;
        boolean inStackTrace2 = this.stackTraceProcessor.process(actualText, (Function2<? super String, ? super LogType, Unit>)((Function2)new Function2<String, LogType, Unit>(this){
            final /* synthetic */ TeamCityMessageCommonClient this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String line, @NotNull LogType logType) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Intrinsics.checkNotNullParameter((Object)((Object)logType), (String)"logType");
                TeamCityServiceMessagesKt.processLogMessage(this.this$0.getLog$kotlin_gradle_plugin(), line, logType);
                TeamCityMessageCommonClient.access$getErrors$p(this.this$0).add(StringUtilsKt.clearAnsiColor(line));
            }
        }));
        if (inStackTrace2) {
            return;
        }
        LogType logType = type;
        if (logType == null ? false : logType.isErrorLike()) {
            this.errors.add(StringUtilsKt.clearAnsiColor(actualText));
        }
        if ((logType = type) != null) {
            LogType logType2;
            LogType it = logType2 = logType;
            boolean bl = false;
            TeamCityServiceMessagesKt.processLogMessage(this.getLog$kotlin_gradle_plugin(), actualText, it);
        }
    }

    @Override
    public void regularText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.clientType == LogType.ERROR || this.clientType == LogType.WARN) {
            this.printMessage(text, this.clientType);
        } else {
            this.printMessage(text, LogType.DEBUG);
        }
    }

    public static final /* synthetic */ List access$getErrors$p(TeamCityMessageCommonClient $this) {
        return $this.errors;
    }
}

