/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.ExtractableMetadataFiles;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadataKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.ModuleDependencyIdentifier;
import org.jetbrains.kotlin.gradle.plugin.mpp.ModuleIds;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.SourceSetMetadataLayout;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/JarArtifactMppDependencyMetadataExtractor;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyMetadataExtractor;", "project", "Lorg/gradle/api/Project;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "primaryArtifact", "Ljava/io/File;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/result/ResolvedComponentResult;Ljava/io/File;)V", "metadataArtifactBySourceSet", "", "", "getMetadataArtifactBySourceSet", "()Ljava/util/Map;", "getPrimaryArtifact", "()Ljava/io/File;", "getExtractableMetadataFiles", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ExtractableMetadataFiles;", "visibleSourceSetNames", "", "baseDir", "getProjectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "parseJsonProjectStructureMetadata", "input", "Ljava/io/InputStream;", "parseXmlProjectStructureMetadata", "JarExtractableMetadataFiles", "kotlin-gradle-plugin"})
public class JarArtifactMppDependencyMetadataExtractor
extends MppDependencyMetadataExtractor {
    @NotNull
    private final File primaryArtifact;
    @NotNull
    private final Map<String, File> metadataArtifactBySourceSet;

    public JarArtifactMppDependencyMetadataExtractor(@NotNull Project project, @NotNull ResolvedComponentResult dependency2, @NotNull File primaryArtifact) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)primaryArtifact, (String)"primaryArtifact");
        super(project, dependency2);
        this.primaryArtifact = primaryArtifact;
        this.metadataArtifactBySourceSet = new LinkedHashMap();
    }

    @NotNull
    public final File getPrimaryArtifact() {
        return this.primaryArtifact;
    }

    @NotNull
    public final Map<String, File> getMetadataArtifactBySourceSet() {
        return this.metadataArtifactBySourceSet;
    }

    private final KotlinProjectStructureMetadata parseJsonProjectStructureMetadata(InputStream input) {
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        return KotlinProjectStructureMetadataKt.parseKotlinSourceSetMetadataFromJson(TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset)));
    }

    private final KotlinProjectStructureMetadata parseXmlProjectStructureMetadata(InputStream input) {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"newInstance().newDocumentBuilder().parse(input)");
        return KotlinProjectStructureMetadataKt.parseKotlinSourceSetMetadataFromXml(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KotlinProjectStructureMetadata getProjectStructureMetadata() {
        KotlinProjectStructureMetadata kotlinProjectStructureMetadata;
        Closeable closeable = new ZipFile(this.primaryArtifact);
        Throwable throwable = null;
        try {
            Object object;
            Pair pair;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            ZipEntry zipEntry = zip.getEntry("META-INF/kotlin-project-structure-metadata.json");
            if (zipEntry == null) {
                ZipEntry zipEntry2 = zip.getEntry("META-INF/kotlin-project-structure-metadata.xml");
                if (zipEntry2 == null) {
                    KotlinProjectStructureMetadata kotlinProjectStructureMetadata2 = null;
                    return kotlinProjectStructureMetadata2;
                }
                pair = TuplesKt.to((Object)zipEntry2, (Object)new Function1<InputStream, KotlinProjectStructureMetadata>((Object)this){

                    @Nullable
                    public final KotlinProjectStructureMetadata invoke(@NotNull InputStream p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return JarArtifactMppDependencyMetadataExtractor.access$parseXmlProjectStructureMetadata((JarArtifactMppDependencyMetadataExtractor)this.receiver, p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "parseXmlProjectStructureMetadata(Ljava/io/InputStream;)Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;";
                    }

                    @NotNull
                    public final String getName() {
                        return "parseXmlProjectStructureMetadata";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JarArtifactMppDependencyMetadataExtractor.class);
                    }
                });
            } else {
                pair = TuplesKt.to((Object)zipEntry, (Object)new Function1<InputStream, KotlinProjectStructureMetadata>((Object)this){

                    @Nullable
                    public final KotlinProjectStructureMetadata invoke(@NotNull InputStream p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return JarArtifactMppDependencyMetadataExtractor.access$parseJsonProjectStructureMetadata((JarArtifactMppDependencyMetadataExtractor)this.receiver, p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "parseJsonProjectStructureMetadata(Ljava/io/InputStream;)Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;";
                    }

                    @NotNull
                    public final String getName() {
                        return "parseJsonProjectStructureMetadata";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JarArtifactMppDependencyMetadataExtractor.class);
                    }
                });
            }
            Pair pair2 = pair;
            ZipEntry metadata2 = (ZipEntry)pair2.component1();
            KFunction parseFunction = (KFunction)pair2.component2();
            Closeable closeable2 = zip.getInputStream(metadata2);
            Throwable throwable2 = null;
            try {
                object = ((Function1)parseFunction).invoke((Object)closeable2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            kotlinProjectStructureMetadata = (KotlinProjectStructureMetadata)object;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return kotlinProjectStructureMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExtractableMetadataFiles getExtractableMetadataFiles(@NotNull Set<String> visibleSourceSetNames, @NotNull File baseDir) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(visibleSourceSetNames, (String)"visibleSourceSetNames");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        File primaryArtifact = this.primaryArtifact;
        ModuleDependencyIdentifier moduleId = ModuleIds.INSTANCE.fromComponent(this.getProject(), this.getComponent());
        Object object = visibleSourceSetNames;
        File file = baseDir;
        Project project = this.getProject();
        ModuleDependencyIdentifier moduleDependencyIdentifier = moduleId;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var8_12 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            File file2 = this.getMetadataArtifactBySourceSet().get(it);
            Pair pair = TuplesKt.to((Object)it, (Object)(file2 == null ? primaryArtifact : file2));
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        ModuleDependencyIdentifier moduleDependencyIdentifier2 = moduleDependencyIdentifier;
        Project project2 = project;
        File file3 = file;
        Map map2 = map;
        object = this.getProjectStructureMetadata();
        if (object == null) {
            map = map2;
            file = file3;
            project = project2;
            moduleDependencyIdentifier = moduleDependencyIdentifier2;
            boolean bl = false;
            String string = "project structure metadata is needed to extract files";
            ModuleDependencyIdentifier moduleDependencyIdentifier3 = moduleDependencyIdentifier;
            Project project3 = project;
            File file4 = file;
            Map map3 = map;
            String string2 = string;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Object object2 = object;
        Map map4 = map2;
        File file5 = file3;
        Project project4 = project2;
        ModuleDependencyIdentifier moduleDependencyIdentifier4 = moduleDependencyIdentifier2;
        return new JarExtractableMetadataFiles(moduleDependencyIdentifier4, project4, file5, map4, (KotlinProjectStructureMetadata)object2);
    }

    public static final /* synthetic */ KotlinProjectStructureMetadata access$parseJsonProjectStructureMetadata(JarArtifactMppDependencyMetadataExtractor $this, InputStream input) {
        return $this.parseJsonProjectStructureMetadata(input);
    }

    public static final /* synthetic */ KotlinProjectStructureMetadata access$parseXmlProjectStructureMetadata(JarArtifactMppDependencyMetadataExtractor $this, InputStream input) {
        return $this.parseXmlProjectStructureMetadata(input);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/JarArtifactMppDependencyMetadataExtractor$JarExtractableMetadataFiles;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ExtractableMetadataFiles;", "module", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;", "project", "Lorg/gradle/api/Project;", "baseDir", "Ljava/io/File;", "artifactBySourceSet", "", "", "projectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/ModuleDependencyIdentifier;Lorg/gradle/api/Project;Ljava/io/File;Ljava/util/Map;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;)V", "getMetadataFilesPerSourceSet", "Lorg/gradle/api/file/FileCollection;", "doProcessFiles", "", "kotlin-gradle-plugin"})
    private static final class JarExtractableMetadataFiles
    extends ExtractableMetadataFiles {
        @NotNull
        private final ModuleDependencyIdentifier module;
        @NotNull
        private final Project project;
        @NotNull
        private final File baseDir;
        @NotNull
        private final Map<String, File> artifactBySourceSet;
        @NotNull
        private final KotlinProjectStructureMetadata projectStructureMetadata;

        public JarExtractableMetadataFiles(@NotNull ModuleDependencyIdentifier module2, @NotNull Project project, @NotNull File baseDir, @NotNull Map<String, ? extends File> artifactBySourceSet, @NotNull KotlinProjectStructureMetadata projectStructureMetadata) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter(artifactBySourceSet, (String)"artifactBySourceSet");
            Intrinsics.checkNotNullParameter((Object)projectStructureMetadata, (String)"projectStructureMetadata");
            this.module = module2;
            this.project = project;
            this.baseDir = baseDir;
            this.artifactBySourceSet = artifactBySourceSet;
            this.projectStructureMetadata = projectStructureMetadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Map<String, FileCollection> getMetadataFilesPerSourceSet(boolean doProcessFiles) {
            File file;
            JarExtractableMetadataFiles jarExtractableMetadataFiles;
            String moduleString = this.module.getGroupId() + '-' + this.module.getModuleId();
            JarExtractableMetadataFiles $this$getMetadataFilesPerSourceSet_u24lambda_u2d1 = jarExtractableMetadataFiles = this;
            boolean bl = false;
            File it = file = FilesKt.resolve((File)$this$getMetadataFilesPerSourceSet_u24lambda_u2d1.baseDir, (String)moduleString);
            boolean bl2 = false;
            it.mkdirs();
            File transformedModuleRoot = file;
            Map resultFiles = new LinkedHashMap();
            KotlinProjectStructureMetadata projectStructureMetadata = this.projectStructureMetadata;
            Map<String, File> $this$forEach$iv = this.artifactBySourceSet;
            boolean $i$f$forEach = false;
            Map<String, File> map = $this$forEach$iv;
            boolean bl3 = false;
            Iterator<Map.Entry<String, File>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, File> element$iv;
                Map.Entry<String, File> $dstr$sourceSetName$artifact = element$iv = iterator.next();
                boolean bl4 = false;
                Map.Entry<String, File> entry = $dstr$sourceSetName$artifact;
                String sourceSetName = entry.getKey();
                Map.Entry<String, File> entry2 = $dstr$sourceSetName$artifact;
                File artifact2 = entry2.getValue();
                SourceSetMetadataLayout sourceSetMetadataLayout = projectStructureMetadata.getSourceSetBinaryLayout().get(sourceSetName);
                String extension = sourceSetMetadataLayout == null ? SourceSetMetadataLayout.METADATA.INSTANCE.getArchiveExtension() : sourceSetMetadataLayout.getArchiveExtension();
                File extractToJarFile = FilesKt.resolve((File)transformedModuleRoot, (String)(moduleString + '-' + sourceSetName + '.' + extension));
                Object object = resultFiles;
                Object[] objectArray = new Object[]{extractToJarFile};
                Object object2 = this.project.files(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.files(extractToJarFile)");
                object.put(sourceSetName, object2);
                if (!doProcessFiles) continue;
                if (extractToJarFile.exists()) {
                    extractToJarFile.delete();
                }
                if (!artifact2.isFile()) continue;
                object = new ZipFile(artifact2);
                object2 = null;
                try {
                    ZipFile zip = (ZipFile)object;
                    boolean bl5 = false;
                    Object object3 = zip.entries();
                    Intrinsics.checkNotNullExpressionValue(object3, (String)"zip.entries()");
                    List entries2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(object3)), (Function1)((Function1)new Function1<ZipEntry, Boolean>(sourceSetName){
                        final /* synthetic */ String $sourceSetName;
                        {
                            this.$sourceSetName = $sourceSetName;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(ZipEntry it) {
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            return StringsKt.startsWith$default((String)string, (String)Intrinsics.stringPlus((String)this.$sourceSetName, (Object)"/"), (boolean)false, (int)2, null);
                        }
                    })));
                    if (CollectionsKt.any((Iterable)entries2)) {
                        object3 = new ZipOutputStream(new FileOutputStream(extractToJarFile));
                        Throwable throwable = null;
                        try {
                            ZipOutputStream resultZipOutput = (ZipOutputStream)object3;
                            boolean bl6 = false;
                            for (ZipEntry entry3 : entries2) {
                                if (entry3.isDirectory()) continue;
                                Object object4 = entry3.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"entry.name");
                                ZipEntry resultEntry = new ZipEntry(StringsKt.substringAfter$default((String)object4, (String)"/", null, (int)2, null));
                                object4 = zip.getInputStream(entry3);
                                Throwable throwable2 = null;
                                try {
                                    InputStream inputStream = (InputStream)object4;
                                    boolean bl7 = false;
                                    resultZipOutput.putNextEntry(resultEntry);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                                    ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)resultZipOutput, (int)0, (int)2, null);
                                    resultZipOutput.closeEntry();
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable2);
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
                        }
                    }
                    objectArray = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
            }
            return resultFiles;
        }
    }
}

