/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "", "outputs", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/file/FileCollection;)V", "previousOutputs", "", "Ljava/io/File;", "", "restoreOutputs", "", "kotlin-gradle-plugin"})
public final class TaskOutputsBackup {
    @NotNull
    private final FileCollection outputs;
    @NotNull
    private final Map<File, byte[]> previousOutputs;

    public TaskOutputsBackup(@NotNull FileCollection outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        this.outputs = outputs;
        HashSet<File> outputFiles = new HashSet<File>();
        Iterable $this$forEach$iv = (Iterable)this.outputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Sequence $this$filterTo$iv = (Sequence)FilesKt.walk$default((File)it, null, (int)1, null);
                boolean $i$f$filterTo = false;
                for (Object element$iv2 : $this$filterTo$iv) {
                    File p0 = (File)element$iv2;
                    boolean bl2 = false;
                    if (!p0.isFile()) continue;
                    ((Collection)outputFiles).add(element$iv2);
                }
                continue;
            }
            if (!it.isFile()) continue;
            outputFiles.add(it);
        }
        this.previousOutputs = CollectionsKt.keysToMap((Iterable)outputFiles, (Function1)2.INSTANCE);
    }

    public final void restoreOutputs() {
        Iterable $this$forEach$iv = (Iterable)this.outputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FilesKt.deleteRecursively((File)it);
                continue;
            }
            if (!it.isFile()) continue;
            it.delete();
        }
        HashSet<File> dirs = new HashSet<File>();
        for (Map.Entry<File, byte[]> entry : this.previousOutputs.entrySet()) {
            File file = entry.getKey();
            byte[] bytes = entry.getValue();
            File dir2 = file.getParentFile();
            if (dirs.add(dir2)) {
                dir2.mkdirs();
            }
            FilesKt.writeBytes((File)file, (byte[])bytes);
        }
    }
}

