/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0014\u0010\u0012\u001a\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0013\u001a'\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00022\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0016\"\u00020\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u000e\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t\u001a'\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0016\"\u00020\t\u00a2\u0006\u0002\u0010\u001a\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\b*\u00020\u0002\u001a\u0015\u0010\u001c\u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u001f\u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010 \u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0004\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0002\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\b*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0004\u00a8\u0006#"}, d2={"identityString", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "getIdentityString", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "(Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;)Ljava/lang/String;", "konanTargets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getKonanTargets", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Ljava/util/Set;", "level", "", "getLevel", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)I", "prettyName", "getPrettyName", "CommonizerTarget", "", "commonizerTarget", "commonizerTargets", "", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;[Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/LeafCommonizerTarget;", "konanTarget", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;[Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "allLeaves", "isAncestorOf", "", "other", "isDescendentOf", "isEqualOrAncestorOf", "highlightedChild", "withAllAncestors", "kotlin-klib-commonizer-api"})
public final class CommonizerTargetKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommonizerTarget CommonizerTarget(@NotNull Iterable<? extends KonanTarget> konanTargets) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(konanTargets, (String)"konanTargets");
        Set konanTargetsSet = CollectionsKt.toSet(konanTargets);
        Collection collection = konanTargetsSet;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Empty set of of konanTargets";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = konanTargetsSet;
        boolean $i$f$map = false;
        Iterable bl4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KonanTarget konanTarget = (KonanTarget)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            LeafCommonizerTarget leafCommonizerTarget = new LeafCommonizerTarget((KonanTarget)p0);
            collection2.add(leafCommonizerTarget);
        }
        List leafTargets = (List)destination$iv$iv;
        LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)CollectionsKt.singleOrNull((List)leafTargets);
        return leafCommonizerTarget == null ? (CommonizerTarget)new SharedCommonizerTarget(CollectionsKt.toSet((Iterable)leafTargets)) : (CommonizerTarget)leafCommonizerTarget;
    }

    @NotNull
    public static final LeafCommonizerTarget CommonizerTarget(@NotNull KonanTarget konanTarget) {
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        return new LeafCommonizerTarget(konanTarget);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SharedCommonizerTarget CommonizerTarget(@NotNull KonanTarget konanTarget, KonanTarget ... konanTargets) {
        Collection<LeafCommonizerTarget> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)konanTarget, (String)"konanTarget");
        Intrinsics.checkNotNullParameter((Object)konanTargets, (String)"konanTargets");
        ArrayList<KonanTarget> arrayList = new ArrayList<KonanTarget>(konanTargets.length + 1);
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<KonanTarget> $this$CommonizerTarget_u24lambda_u2d1 = arrayList;
        boolean bl3 = false;
        $this$CommonizerTarget_u24lambda_u2d1.add(konanTarget);
        CollectionsKt.addAll((Collection)$this$CommonizerTarget_u24lambda_u2d1, (Object[])konanTargets);
        ArrayList<KonanTarget> targets = arrayList;
        Iterable $this$map$iv = targets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KonanTarget konanTarget2 = (KonanTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            LeafCommonizerTarget leafCommonizerTarget = new LeafCommonizerTarget((KonanTarget)p0);
            collection.add(leafCommonizerTarget);
        }
        collection = (List)destination$iv$iv;
        Set set = CollectionsKt.toSet((Iterable)collection);
        return new SharedCommonizerTarget(set);
    }

    @NotNull
    public static final SharedCommonizerTarget CommonizerTarget(@NotNull CommonizerTarget commonizerTarget, CommonizerTarget ... commonizerTargets) {
        Intrinsics.checkNotNullParameter((Object)commonizerTarget, (String)"commonizerTarget");
        Intrinsics.checkNotNullParameter((Object)commonizerTargets, (String)"commonizerTargets");
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$CommonizerTarget_u24lambda_u2d3 = list;
        boolean bl4 = false;
        $this$CommonizerTarget_u24lambda_u2d3.add(commonizerTarget);
        CollectionsKt.addAll((Collection)$this$CommonizerTarget_u24lambda_u2d3, (Object[])commonizerTargets);
        List targets = list;
        return new SharedCommonizerTarget(CollectionsKt.toSet((Iterable)targets));
    }

    @NotNull
    public static final String getIdentityString(@NotNull CommonizerTarget $this$identityString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$identityString, (String)"<this>");
        CommonizerTarget commonizerTarget = $this$identityString;
        if (commonizerTarget instanceof LeafCommonizerTarget) {
            string = ((LeafCommonizerTarget)$this$identityString).getName();
        } else if (commonizerTarget instanceof SharedCommonizerTarget) {
            string = CommonizerTargetKt.getIdentityString((SharedCommonizerTarget)$this$identityString);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getIdentityString(SharedCommonizerTarget $this$identityString) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$identityString.getTargets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            CommonizerTarget commonizerTarget = (CommonizerTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = CommonizerTargetKt.getIdentityString((CommonizerTarget)p0);
            collection.add(string);
        }
        List segments = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        return CollectionsKt.joinToString$default((Iterable)segments, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public static final String getPrettyName(@NotNull CommonizerTarget $this$prettyName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$prettyName, (String)"<this>");
        CommonizerTarget commonizerTarget = $this$prettyName;
        if (commonizerTarget instanceof LeafCommonizerTarget) {
            string = '[' + ((LeafCommonizerTarget)$this$prettyName).getName() + ']';
        } else if (commonizerTarget instanceof SharedCommonizerTarget) {
            string = CommonizerTargetKt.prettyName((SharedCommonizerTarget)$this$prettyName, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final String prettyName(@NotNull SharedCommonizerTarget $this$prettyName, @Nullable CommonizerTarget highlightedChild) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyName, (String)"<this>");
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                CommonizerTarget it = (CommonizerTarget)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(CommonizerTargetKt.getLevel(it));
                it = (CommonizerTarget)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Integer.valueOf(CommonizerTargetKt.getLevel(it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        boolean bl2 = false;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$prettyName.getTargets(), (Comparator)new Comparator<T>(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    CommonizerTarget it = (CommonizerTarget)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)CommonizerTargetKt.getIdentityString(it));
                    it = (CommonizerTarget)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = (Comparable)((Object)CommonizerTargetKt.getIdentityString(it));
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        }), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)((Function1)new Function1<CommonizerTarget, CharSequence>(highlightedChild){
            final /* synthetic */ CommonizerTarget $highlightedChild;
            {
                this.$highlightedChild = $highlightedChild;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull CommonizerTarget child) {
                String string;
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                CommonizerTarget commonizerTarget = child;
                if (commonizerTarget instanceof LeafCommonizerTarget) {
                    string = ((LeafCommonizerTarget)child).getName();
                } else if (commonizerTarget instanceof SharedCommonizerTarget) {
                    string = CommonizerTargetKt.prettyName((SharedCommonizerTarget)child, this.$highlightedChild);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return Intrinsics.stringPlus((String)string, (Object)(Intrinsics.areEqual((Object)child, (Object)this.$highlightedChild) ? "(*)" : ""));
            }
        }), (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KonanTarget> getKonanTargets(@NotNull CommonizerTarget $this$konanTargets) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)$this$konanTargets, (String)"<this>");
        CommonizerTarget commonizerTarget = $this$konanTargets;
        if (commonizerTarget instanceof LeafCommonizerTarget) {
            set = SetsKt.setOf((Object)((LeafCommonizerTarget)$this$konanTargets).getKonanTarget());
        } else if (commonizerTarget instanceof SharedCommonizerTarget) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((SharedCommonizerTarget)$this$konanTargets).getTargets();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CommonizerTarget it = (CommonizerTarget)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = CommonizerTargetKt.getKonanTargets(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    public static final int getLevel(@NotNull CommonizerTarget $this$level) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$level, (String)"<this>");
        CommonizerTarget commonizerTarget = $this$level;
        if (commonizerTarget instanceof LeafCommonizerTarget) {
            return 0;
        }
        if (commonizerTarget instanceof SharedCommonizerTarget) {
            Iterable iterable = ((SharedCommonizerTarget)$this$level).getTargets();
            boolean bl = false;
            if (!iterable.isEmpty()) {
                iterable = ((SharedCommonizerTarget)$this$level).getTargets();
                bl = false;
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    throw (Throwable)new NoSuchElementException();
                }
                CommonizerTarget it = (CommonizerTarget)iterator.next();
                boolean bl2 = false;
                int n2 = CommonizerTargetKt.getLevel(it);
                while (iterator.hasNext()) {
                    CommonizerTarget it2 = (CommonizerTarget)iterator.next();
                    $i$a$-maxOf-CommonizerTargetKt$level$1 = false;
                    int n3 = CommonizerTargetKt.getLevel(it2);
                    if (n2 >= n3) continue;
                    n2 = n3;
                }
                n = n2 + 1;
            } else {
                n = 0;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<CommonizerTarget> withAllAncestors(@NotNull CommonizerTarget $this$withAllAncestors) {
        Collection collection;
        Set set;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)$this$withAllAncestors, (String)"<this>");
        Set set2 = SetsKt.setOf((Object)$this$withAllAncestors);
        boolean $i$f$transitiveClosure = false;
        Object $this$withAllAncestors_u24lambda_u2d92 = $this$withAllAncestors;
        boolean bl = false;
        CommonizerTarget commonizerTarget = $this$withAllAncestors_u24lambda_u2d92;
        if (commonizerTarget instanceof SharedCommonizerTarget) {
            iterable = ((SharedCommonizerTarget)$this$withAllAncestors_u24lambda_u2d92).getTargets();
        } else if (commonizerTarget instanceof LeafCommonizerTarget) {
            iterable = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Iterable initialEdges$iv = iterable;
        if (initialEdges$iv instanceof Collection && ((Collection)initialEdges$iv).isEmpty()) {
            set = SetsKt.emptySet();
        } else {
            List list;
            boolean $i$f$deque = false;
            if (KotlinVersion.CURRENT.isAtLeast(1, 4)) {
                list = (List)new ArrayDeque();
            } else {
                boolean $this$withAllAncestors_u24lambda_u2d92 = false;
                list = new ArrayList();
            }
            List queue$iv = list;
            boolean $this$withAllAncestors_u24lambda_u2d92 = false;
            Set results$iv = new LinkedHashSet();
            CollectionsKt.addAll((Collection)queue$iv, (Iterable)initialEdges$iv);
            while (true) {
                Iterable iterable2;
                void $this$withAllAncestors_u24lambda_u2d93;
                $this$withAllAncestors_u24lambda_u2d92 = queue$iv;
                boolean bl2 = false;
                if (!(!$this$withAllAncestors_u24lambda_u2d92.isEmpty())) break;
                Object resolved$iv = queue$iv.remove(0);
                if (Intrinsics.areEqual(resolved$iv, (Object)$this$withAllAncestors) || !results$iv.add(resolved$iv)) continue;
                commonizerTarget = (CommonizerTarget)resolved$iv;
                collection = queue$iv;
                $i$a$-transitiveClosure-CommonizerTargetKt$withAllAncestors$1 = false;
                void var9_13 = $this$withAllAncestors_u24lambda_u2d93;
                if (var9_13 instanceof SharedCommonizerTarget) {
                    iterable2 = ((SharedCommonizerTarget)$this$withAllAncestors_u24lambda_u2d93).getTargets();
                } else if (var9_13 instanceof LeafCommonizerTarget) {
                    iterable2 = CollectionsKt.emptyList();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Iterable iterable3 = iterable2;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable3);
            }
            set = CollectionsKt.toSet((Iterable)results$iv);
        }
        collection = set;
        return SetsKt.plus((Set)set2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<LeafCommonizerTarget> allLeaves(@NotNull CommonizerTarget $this$allLeaves) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$allLeaves, (String)"<this>");
        Iterable $this$filterIsInstance$iv = CommonizerTargetKt.withAllAncestors($this$allLeaves);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LeafCommonizerTarget)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAncestorOf(@NotNull CommonizerTarget $this$isAncestorOf, @NotNull CommonizerTarget other) {
        CommonizerTarget it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAncestorOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!($this$isAncestorOf instanceof SharedCommonizerTarget)) return false;
        Iterable $this$any$iv = ((SharedCommonizerTarget)$this$isAncestorOf).getTargets();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (CommonizerTarget)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)other)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = ((SharedCommonizerTarget)$this$isAncestorOf).getTargets();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (CommonizerTarget)element$iv;
            boolean bl3 = false;
        } while (!CommonizerTargetKt.isAncestorOf(it, other));
        return true;
    }

    public static final boolean isEqualOrAncestorOf(@NotNull CommonizerTarget $this$isEqualOrAncestorOf, @NotNull CommonizerTarget other) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrAncestorOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$isEqualOrAncestorOf, (Object)other) || CommonizerTargetKt.isAncestorOf($this$isEqualOrAncestorOf, other);
    }

    public static final boolean isDescendentOf(@NotNull CommonizerTarget $this$isDescendentOf, @NotNull CommonizerTarget other) {
        Intrinsics.checkNotNullParameter((Object)$this$isDescendentOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return CommonizerTargetKt.isAncestorOf(other, $this$isDescendentOf);
    }
}

