/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirName;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirValueParameter;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.Commonizer;
import org.jetbrains.kotlin.commonizer.core.NullableSingleInvocationCommonizerKt;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.utils.MiscKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/ValueParameterCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirValueParameter;", "returnTypeCommonizer", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;)V", "name", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "Lorg/jetbrains/kotlin/commonizer/core/Commonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "varargElementType", "isCrossinline", "", "isNoinline", "commonizationResult", "initialize", "", "first", "doCommonizeWith", "next", "overwriteName", "kotlin-klib-commonizer"})
public final class ValueParameterCommonizer
extends AbstractStandardCommonizer<CirValueParameter, CirValueParameter> {
    private CirName name;
    @NotNull
    private final Commonizer<CirType, CirType> returnTypeCommonizer;
    @Nullable
    private CirType varargElementType;
    private boolean isCrossinline;
    private boolean isNoinline;

    public ValueParameterCommonizer(@NotNull TypeCommonizer returnTypeCommonizer) {
        Intrinsics.checkNotNullParameter((Object)returnTypeCommonizer, (String)"returnTypeCommonizer");
        this.returnTypeCommonizer = NullableSingleInvocationCommonizerKt.asCommonizer(returnTypeCommonizer);
        this.isCrossinline = true;
        this.isNoinline = true;
    }

    @Override
    @Nullable
    protected CirValueParameter commonizationResult() {
        List list = CollectionsKt.emptyList();
        CirName cirName = this.name;
        if (cirName == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            cirName = null;
        }
        CirType cirType = this.returnTypeCommonizer.getResult();
        if (cirType == null) {
            return null;
        }
        return CirValueParameter.Companion.createInterned(list, cirName, cirType, this.varargElementType, false, this.isCrossinline, this.isNoinline);
    }

    @Override
    protected void initialize(@NotNull CirValueParameter first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.name = first.getName();
        this.varargElementType = first.getVarargElementType();
        this.isCrossinline = first.isCrossinline();
        this.isNoinline = first.isNoinline();
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirValueParameter next) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        boolean bl = result = !next.getDeclaresDefaultValue() && MiscKt.isNull(this.varargElementType) == MiscKt.isNull(next.getVarargElementType()) && this.returnTypeCommonizer.commonizeWith(next.getReturnType());
        if (result) {
            this.isCrossinline = this.isCrossinline && next.isCrossinline();
            this.isNoinline = this.isNoinline && next.isNoinline();
        }
        return result;
    }

    public final void overwriteName(@NotNull CirName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }
}

