/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibraryLayout;
import org.jetbrains.kotlin.library.impl.ExtractingBaseLibraryImpl;
import org.jetbrains.kotlin.library.impl.FromZipBaseLibraryImpl;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImplKt;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00018VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "klib", "Lorg/jetbrains/kotlin/konan/file/File;", "component", "", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "getComponent", "()Ljava/lang/String;", "extractingToTemp", "getExtractingToTemp", "()Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "extractingToTemp$delegate", "Lkotlin/Lazy;", "isZipped", "", "()Z", "getKlib", "()Lorg/jetbrains/kotlin/konan/file/File;", "libFile", "getLibFile", "libraryName", "getLibraryName", "directlyFromZip", "zipFileSystem", "Ljava/nio/file/FileSystem;", "kotlin-util-klib"})
public class KotlinLibraryLayoutImpl
implements KotlinLibraryLayout {
    @NotNull
    private final File klib;
    @Nullable
    private final String component;
    private final boolean isZipped;
    @NotNull
    private final File libFile;
    @NotNull
    private final Lazy extractingToTemp$delegate;

    public KotlinLibraryLayoutImpl(@NotNull File klib, @Nullable String component) {
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        this.klib = klib;
        this.component = component;
        this.isZipped = this.klib.isFile();
        if (this.isZipped) {
            KotlinLibraryLayoutImplKt.zippedKotlinLibraryChecks(this.klib);
        }
        this.libFile = this.isZipped ? new File("/") : this.klib;
        this.extractingToTemp$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExtractingBaseLibraryImpl>(this){
            final /* synthetic */ KotlinLibraryLayoutImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ExtractingBaseLibraryImpl invoke() {
                return new ExtractingBaseLibraryImpl(this.this$0);
            }
        }));
    }

    @NotNull
    public final File getKlib() {
        return this.klib;
    }

    @Override
    @Nullable
    public String getComponent() {
        return this.component;
    }

    public final boolean isZipped() {
        return this.isZipped;
    }

    @Override
    @NotNull
    public File getLibFile() {
        return this.libFile;
    }

    @Override
    @NotNull
    public String getLibraryName() {
        return this.isZipped ? UtilKt.removeSuffixIfPresent((String)this.klib.getPath(), (String)".klib") : this.getLibFile().getPath();
    }

    @NotNull
    public KotlinLibraryLayout getExtractingToTemp() {
        Lazy lazy = this.extractingToTemp$delegate;
        return (KotlinLibraryLayout)lazy.getValue();
    }

    @NotNull
    public KotlinLibraryLayout directlyFromZip(@NotNull FileSystem zipFileSystem) {
        Intrinsics.checkNotNullParameter((Object)zipFileSystem, (String)"zipFileSystem");
        return new FromZipBaseLibraryImpl(this, zipFileSystem);
    }

    @Override
    @NotNull
    public File getComponentDir() {
        return KotlinLibraryLayout.DefaultImpls.getComponentDir(this);
    }

    @Override
    @NotNull
    public File getManifestFile() {
        return KotlinLibraryLayout.DefaultImpls.getManifestFile(this);
    }

    @Override
    @NotNull
    public File getResourcesDir() {
        return KotlinLibraryLayout.DefaultImpls.getResourcesDir(this);
    }

    @Override
    @NotNull
    public File getPre_1_4_manifest() {
        return KotlinLibraryLayout.DefaultImpls.getPre_1_4_manifest(this);
    }
}

