/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.reactive;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.LinkedListChannel;
import kotlinx.coroutines.internal.LockFreeLinkedListNode;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u001c2\b\u0012\u0004\u0012\u00028\u00000\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\fJ\u000f\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\fJ\u0017\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lkotlinx/coroutines/reactive/SubscriptionChannel;", "T", "", "request", "<init>", "(I)V", "Lkotlinx/coroutines/internal/LockFreeLinkedListNode;", "closed", "", "onClosedIdempotent", "(Lkotlinx/coroutines/internal/LockFreeLinkedListNode;)V", "onComplete", "()V", "", "e", "onError", "(Ljava/lang/Throwable;)V", "t", "onNext", "(Ljava/lang/Object;)V", "onReceiveDequeued", "onReceiveEnqueued", "Lorg/reactivestreams/Subscription;", "s", "onSubscribe", "(Lorg/reactivestreams/Subscription;)V", "I", "kotlinx-coroutines-reactive", "Lkotlinx/coroutines/channels/LinkedListChannel;", "Lorg/reactivestreams/Subscriber;"})
final class SubscriptionChannel<T>
extends LinkedListChannel<T>
implements Subscriber<T> {
    private final int request;
    @NotNull
    private volatile /* synthetic */ Object _subscription;
    private static final /* synthetic */ AtomicReferenceFieldUpdater _subscription$FU;
    @NotNull
    private volatile /* synthetic */ int _requested;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _requested$FU;

    public SubscriptionChannel(int request) {
        super(null);
        this.request = request;
        boolean bl = this.request >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid request size: ", (Object)this.request);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this._subscription = null;
        this._requested = 0;
    }

    public void onReceiveEnqueued() {
        SubscriptionChannel $this$loop$iv = this;
        boolean $i$f$loop = false;
        while (true) {
            int wasRequested = $this$loop$iv._requested;
            boolean bl = false;
            Subscription subscription = (Subscription)this._subscription;
            int needRequested = wasRequested - 1;
            if (subscription != null && needRequested < 0) {
                if (wasRequested != this.request && !_requested$FU.compareAndSet(this, wasRequested, this.request)) continue;
                subscription.request((long)(this.request - needRequested));
                return;
            }
            if (_requested$FU.compareAndSet(this, wasRequested, needRequested)) break;
        }
    }

    public void onReceiveDequeued() {
        _requested$FU.incrementAndGet(this);
    }

    public void onClosedIdempotent(@NotNull LockFreeLinkedListNode closed) {
        Subscription subscription = _subscription$FU.getAndSet(this, null);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public void onSubscribe(@NotNull Subscription s) {
        int wasRequested;
        this._subscription = s;
        do {
            if (this.isClosedForSend()) {
                s.cancel();
                return;
            }
            wasRequested = this._requested;
            if (wasRequested < this.request) continue;
            return;
        } while (!_requested$FU.compareAndSet(this, wasRequested, this.request));
        s.request((long)(this.request - wasRequested));
    }

    public void onNext(T t) {
        _requested$FU.decrementAndGet(this);
        this.trySend-JP2dKIU(t);
    }

    public void onComplete() {
        this.close(null);
    }

    public void onError(@NotNull Throwable e) {
        this.close(e);
    }

    static {
        _subscription$FU = AtomicReferenceFieldUpdater.newUpdater(SubscriptionChannel.class, Object.class, "_subscription");
        _requested$FU = AtomicIntegerFieldUpdater.newUpdater(SubscriptionChannel.class, "_requested");
    }
}

