/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.util.Arrays;

public final class ClassMap<V> {
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private Entry<V>[] table;
    private int threshold;
    private int size;

    public ClassMap(int initialCapacity) {
        int initlen;
        if (initialCapacity > 0x20000000) {
            initlen = 0x20000000;
        } else {
            for (initlen = 16; initlen < initialCapacity; initlen <<= 1) {
            }
        }
        this.table = new Entry[initlen];
        this.threshold = (int)((float)initlen * 0.75f);
    }

    public ClassMap() {
        this(64);
    }

    public int size() {
        return this.size;
    }

    public V unsafeGet(Class key) {
        Entry<V>[] tab = this.table;
        Entry<V> e = this.table[key.hashCode() & tab.length - 1];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized V get(Class key) {
        return this.unsafeGet(key);
    }

    private void resize() {
        if (this.size < this.threshold) {
            return;
        }
        Entry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity > 0x20000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        int newMark = newCapacity - 1;
        Entry[] newTable = new Entry[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<V> old = oldTable[i];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index = e.id & newMark;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newTable;
    }

    public synchronized V put(Class key, V value) {
        Entry<V>[] tab = this.table;
        int id = key.hashCode();
        int index = id & tab.length - 1;
        Entry<V> e = this.table[index];
        while (e != null) {
            if (key == e.key) {
                Object existing = e.value;
                e.value = value;
                return existing;
            }
            e = e.next;
        }
        if (this.size >= this.threshold) {
            this.resize();
            tab = this.table;
            index = id & tab.length - 1;
        }
        tab[index] = new Entry(id, key, value, tab[index]);
        ++this.size;
        return null;
    }

    public synchronized void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    private static final class Entry<V> {
        final int id;
        final Class key;
        V value;
        Entry<V> next;

        private Entry(int id, Class key, V value, Entry<V> next) {
            this.value = value;
            this.id = id;
            this.key = key;
            this.next = next;
        }
    }
}

