
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "localTransformations",
    "items",
    "itemsets",
    "associationRules",
    "modelVerification"
})
@JsonRootName("AssociationModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfTransactions",
    "maxNumberOfItemsPerTA",
    "avgNumberOfItemsPerTA",
    "minimumSupport",
    "minimumConfidence",
    "lengthLimit",
    "numberOfItems",
    "numberOfItemsets",
    "numberOfRules",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "localTransformations",
    "items",
    "itemsets",
    "associationRules",
    "modelVerification"
})
public class AssociationModel
    extends Model
    implements HasExtensions<AssociationModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTransactions", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfTransactions")
    private Integer numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTA")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maxNumberOfItemsPerTA")
    private Integer maxNumberOfItemsPerTA;
    @XmlAttribute(name = "avgNumberOfItemsPerTA")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("avgNumberOfItemsPerTA")
    private Number avgNumberOfItemsPerTA;
    @XmlAttribute(name = "minimumSupport", required = true)
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("minimumSupport")
    private Number minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("minimumConfidence")
    private Number minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("lengthLimit")
    private Integer lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfItems")
    private Integer numberOfItems;
    @XmlAttribute(name = "numberOfItemsets", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfItemsets")
    private Integer numberOfItemsets;
    @XmlAttribute(name = "numberOfRules", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfRules")
    private Integer numberOfRules;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Item")
    private List<Item> items;
    @XmlElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Itemset")
    private List<Itemset> itemsets;
    @XmlElement(name = "AssociationRule", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("AssociationRule")
    private List<AssociationRule> associationRules;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371010L;

    public AssociationModel() {
    }

    @ValueConstructor
    public AssociationModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("numberOfTransactions")
        Integer numberOfTransactions,
        @org.jpmml.model.annotations.Property("minimumSupport")
        Number minimumSupport,
        @org.jpmml.model.annotations.Property("minimumConfidence")
        Number minimumConfidence,
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems,
        @org.jpmml.model.annotations.Property("numberOfItemsets")
        Integer numberOfItemsets,
        @org.jpmml.model.annotations.Property("numberOfRules")
        Integer numberOfRules,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.numberOfTransactions = numberOfTransactions;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfItemsets = numberOfItemsets;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
    }

    public String getModelName() {
        return modelName;
    }

    public AssociationModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public AssociationModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public AssociationModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return numberOfTransactions;
    }

    public AssociationModel setNumberOfTransactions(
        @org.jpmml.model.annotations.Property("numberOfTransactions")
        Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTA() {
        return maxNumberOfItemsPerTA;
    }

    public AssociationModel setMaxNumberOfItemsPerTA(
        @org.jpmml.model.annotations.Property("maxNumberOfItemsPerTA")
        Integer maxNumberOfItemsPerTA) {
        this.maxNumberOfItemsPerTA = maxNumberOfItemsPerTA;
        return this;
    }

    public Number getAvgNumberOfItemsPerTA() {
        return avgNumberOfItemsPerTA;
    }

    public AssociationModel setAvgNumberOfItemsPerTA(
        @org.jpmml.model.annotations.Property("avgNumberOfItemsPerTA")
        Number avgNumberOfItemsPerTA) {
        this.avgNumberOfItemsPerTA = avgNumberOfItemsPerTA;
        return this;
    }

    public Number getMinimumSupport() {
        return minimumSupport;
    }

    public AssociationModel setMinimumSupport(
        @org.jpmml.model.annotations.Property("minimumSupport")
        Number minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Number getMinimumConfidence() {
        return minimumConfidence;
    }

    public AssociationModel setMinimumConfidence(
        @org.jpmml.model.annotations.Property("minimumConfidence")
        Number minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return lengthLimit;
    }

    public AssociationModel setLengthLimit(
        @org.jpmml.model.annotations.Property("lengthLimit")
        Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer getNumberOfItems() {
        return numberOfItems;
    }

    public AssociationModel setNumberOfItems(
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer getNumberOfItemsets() {
        return numberOfItemsets;
    }

    public AssociationModel setNumberOfItemsets(
        @org.jpmml.model.annotations.Property("numberOfItemsets")
        Integer numberOfItemsets) {
        this.numberOfItemsets = numberOfItemsets;
        return this;
    }

    public Integer getNumberOfRules() {
        return numberOfRules;
    }

    public AssociationModel setNumberOfRules(
        @org.jpmml.model.annotations.Property("numberOfRules")
        Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public AssociationModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public AssociationModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AssociationModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public AssociationModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public AssociationModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public AssociationModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public AssociationModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasItems() {
        return ((this.items!= null)&&(this.items.size()> 0));
    }

    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    public AssociationModel addItems(Item... items) {
        getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return ((this.itemsets!= null)&&(this.itemsets.size()> 0));
    }

    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public AssociationModel addItemsets(Itemset... itemsets) {
        getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasAssociationRules() {
        return ((this.associationRules!= null)&&(this.associationRules.size()> 0));
    }

    public List<AssociationRule> getAssociationRules() {
        if (associationRules == null) {
            associationRules = new ArrayList<AssociationRule>();
        }
        return this.associationRules;
    }

    public AssociationModel addAssociationRules(AssociationRule... associationRules) {
        getAssociationRules().addAll(Arrays.asList(associationRules));
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public AssociationModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItems()) {
                status = PMMLObject.traverse(visitor, getItems());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemsets()) {
                status = PMMLObject.traverse(visitor, getItemsets());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAssociationRules()) {
                status = PMMLObject.traverse(visitor, getAssociationRules());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
