
package org.dmg.pmml.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasPredicate;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "model",
    "variableWeight"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("Segment")
@JsonPropertyOrder({
    "id",
    "weight",
    "extensions",
    "predicate",
    "model",
    "variableWeight"
})
public class Segment
    extends Entity<String>
    implements HasExtensions<Segment> , HasPredicate<Segment>
{

    @XmlAttribute(name = "id")
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "weight")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("weight")
    private Number weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElements({
        @XmlElement(name = "AnomalyDetectionModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.anomaly_detection.AnomalyDetectionModel.class),
        @XmlElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.association.AssociationModel.class),
        @XmlElement(name = "BayesianNetworkModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.BayesianNetworkModel.class),
        @XmlElement(name = "BaselineModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.baseline.BaselineModel.class),
        @XmlElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.clustering.ClusteringModel.class),
        @XmlElement(name = "GaussianProcessModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.gaussian_process.GaussianProcessModel.class),
        @XmlElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.general_regression.GeneralRegressionModel.class),
        @XmlElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.mining.MiningModel.class),
        @XmlElement(name = "NaiveBayesModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.naive_bayes.NaiveBayesModel.class),
        @XmlElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.nearest_neighbor.NearestNeighborModel.class),
        @XmlElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.neural_network.NeuralNetwork.class),
        @XmlElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.regression.RegressionModel.class),
        @XmlElement(name = "RuleSetModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.rule_set.RuleSetModel.class),
        @XmlElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.sequence.SequenceModel.class),
        @XmlElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.scorecard.Scorecard.class),
        @XmlElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.support_vector_machine.SupportVectorMachineModel.class),
        @XmlElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.text.TextModel.class),
        @XmlElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.time_series.TimeSeriesModel.class),
        @XmlElement(name = "TreeModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.tree.TreeModel.class)
    })
    @JsonProperty("Model")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "AnomalyDetectionModel", value = org.dmg.pmml.anomaly_detection.AnomalyDetectionModel.class),
        @JsonSubTypes.Type(name = "AssociationModel", value = org.dmg.pmml.association.AssociationModel.class),
        @JsonSubTypes.Type(name = "BayesianNetworkModel", value = org.dmg.pmml.bayesian_network.BayesianNetworkModel.class),
        @JsonSubTypes.Type(name = "BaselineModel", value = org.dmg.pmml.baseline.BaselineModel.class),
        @JsonSubTypes.Type(name = "ClusteringModel", value = org.dmg.pmml.clustering.ClusteringModel.class),
        @JsonSubTypes.Type(name = "GaussianProcessModel", value = org.dmg.pmml.gaussian_process.GaussianProcessModel.class),
        @JsonSubTypes.Type(name = "GeneralRegressionModel", value = org.dmg.pmml.general_regression.GeneralRegressionModel.class),
        @JsonSubTypes.Type(name = "MiningModel", value = org.dmg.pmml.mining.MiningModel.class),
        @JsonSubTypes.Type(name = "NaiveBayesModel", value = org.dmg.pmml.naive_bayes.NaiveBayesModel.class),
        @JsonSubTypes.Type(name = "NearestNeighborModel", value = org.dmg.pmml.nearest_neighbor.NearestNeighborModel.class),
        @JsonSubTypes.Type(name = "NeuralNetwork", value = org.dmg.pmml.neural_network.NeuralNetwork.class),
        @JsonSubTypes.Type(name = "RegressionModel", value = org.dmg.pmml.regression.RegressionModel.class),
        @JsonSubTypes.Type(name = "RuleSetModel", value = org.dmg.pmml.rule_set.RuleSetModel.class),
        @JsonSubTypes.Type(name = "SequenceModel", value = org.dmg.pmml.sequence.SequenceModel.class),
        @JsonSubTypes.Type(name = "Scorecard", value = org.dmg.pmml.scorecard.Scorecard.class),
        @JsonSubTypes.Type(name = "SupportVectorMachineModel", value = org.dmg.pmml.support_vector_machine.SupportVectorMachineModel.class),
        @JsonSubTypes.Type(name = "TextModel", value = org.dmg.pmml.text.TextModel.class),
        @JsonSubTypes.Type(name = "TimeSeriesModel", value = org.dmg.pmml.time_series.TimeSeriesModel.class),
        @JsonSubTypes.Type(name = "TreeModel", value = org.dmg.pmml.tree.TreeModel.class)
    })
    private Model model;
    @XmlElement(name = "VariableWeight", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("VariableWeight")
    private VariableWeight variableWeight;
    private final static Number DEFAULT_WEIGHT = new NumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371010L;

    public Segment() {
    }

    @ValueConstructor
    public Segment(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate,
        @org.jpmml.model.annotations.Property("model")
        Model model) {
        this.predicate = predicate;
        this.model = model;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Segment setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Number getWeight() {
        if (weight == null) {
            return DEFAULT_WEIGHT;
        } else {
            return weight;
        }
    }

    public Segment setWeight(
        @org.jpmml.model.annotations.Property("weight")
        Number weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Segment addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate getPredicate() {
        return predicate;
    }

    @Override
    public Segment setPredicate(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public Model getModel() {
        return model;
    }

    public Segment setModel(
        @org.jpmml.model.annotations.Property("model")
        Model model) {
        this.model = model;
        return this;
    }

    public VariableWeight getVariableWeight() {
        return variableWeight;
    }

    public Segment setVariableWeight(
        @org.jpmml.model.annotations.Property("variableWeight")
        VariableWeight variableWeight) {
        this.variableWeight = variableWeight;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate(), getModel(), getVariableWeight());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
