
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "KNNInput", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("KNNInput")
@JsonPropertyOrder({
    "field",
    "fieldWeight",
    "compareFunction",
    "extensions"
})
public class KNNInput
    extends ComparisonField<KNNInput>
    implements HasExtensions<KNNInput>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "fieldWeight")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("fieldWeight")
    private Number fieldWeight;
    @XmlAttribute(name = "compareFunction")
    @JsonProperty("compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Number DEFAULT_FIELD_WEIGHT = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371010L;

    public KNNInput() {
    }

    @ValueConstructor
    public KNNInput(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public KNNInput setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public Number getFieldWeight() {
        if (fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        } else {
            return fieldWeight;
        }
    }

    public KNNInput setFieldWeight(
        @org.jpmml.model.annotations.Property("fieldWeight")
        Number fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    public CompareFunction getCompareFunction() {
        return compareFunction;
    }

    public KNNInput setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public KNNInput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
