
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "FinalTheta", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "thetas"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("FinalTheta")
@JsonPropertyOrder({
    "thetas"
})
public class FinalTheta
    extends org.dmg.pmml.PMMLObject
{

    @XmlElement(name = "Theta", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Theta")
    private List<Theta> thetas;
    private final static long serialVersionUID = 67371010L;

    public FinalTheta() {
    }

    @ValueConstructor
    public FinalTheta(
        @Property("thetas")
        List<Theta> thetas) {
        this.thetas = thetas;
    }

    public boolean hasThetas() {
        return ((this.thetas!= null)&&(this.thetas.size()> 0));
    }

    public List<Theta> getThetas() {
        if (thetas == null) {
            thetas = new ArrayList<Theta>();
        }
        return this.thetas;
    }

    public FinalTheta addThetas(Theta... thetas) {
        getThetas().addAll(Arrays.asList(thetas));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasThetas()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getThetas());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
