/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class RequiredArrayRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;
    public static final String REQUIRED_COMMENT_TEXT = "\n(Required)";

    protected RequiredArrayRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass jclass, Schema schema) {
        ArrayList<String> requiredFieldMethods = new ArrayList<String>();
        JsonNode properties = schema.getContent().get("properties");
        Iterator iterator = node.elements();
        while (iterator.hasNext()) {
            String requiredArrayItem = ((JsonNode)iterator.next()).asText();
            if (requiredArrayItem.isEmpty()) continue;
            JsonNode propertyNode = null;
            if (properties != null) {
                propertyNode = properties.findValue(requiredArrayItem);
            }
            String fieldName = this.ruleFactory.getNameHelper().getPropertyName(requiredArrayItem, propertyNode);
            JFieldVar field = (JFieldVar)jclass.fields().get(fieldName);
            if (field == null) continue;
            this.addJavaDoc((JDocCommentable)field);
            if (this.ruleFactory.getGenerationConfig().isIncludeJsr303Annotations()) {
                this.addNotNullAnnotation(field);
            }
            if (this.ruleFactory.getGenerationConfig().isIncludeJsr305Annotations()) {
                this.addNonnullAnnotation(field);
            }
            requiredFieldMethods.add(this.getGetterName(fieldName, field.type(), node));
            requiredFieldMethods.add(this.getSetterName(fieldName, node));
        }
        this.updateGetterSetterJavaDoc(jclass, requiredFieldMethods);
        return jclass;
    }

    private void updateGetterSetterJavaDoc(JDefinedClass jclass, List<String> requiredFieldMethods) {
        for (JMethod method : jclass.methods()) {
            if (!requiredFieldMethods.contains(method.name())) continue;
            this.addJavaDoc((JDocCommentable)method);
        }
    }

    private void addNotNullAnnotation(JFieldVar field) {
        Class notNullClass = this.ruleFactory.getGenerationConfig().isUseJakartaValidation() ? NotNull.class : javax.validation.constraints.NotNull.class;
        field.annotate(notNullClass);
    }

    private void addNonnullAnnotation(JFieldVar field) {
        field.annotate(Nonnull.class);
    }

    private void addJavaDoc(JDocCommentable docCommentable) {
        JDocComment javadoc = docCommentable.javadoc();
        javadoc.append((Object)REQUIRED_COMMENT_TEXT);
    }

    private String getSetterName(String propertyName, JsonNode node) {
        return this.ruleFactory.getNameHelper().getSetterName(propertyName, node);
    }

    private String getGetterName(String propertyName, JType type, JsonNode node) {
        return this.ruleFactory.getNameHelper().getGetterName(propertyName, type, node);
    }
}

