/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.android;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import org.jupnp.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkUtils.class);

    public static NetworkInfo getConnectedNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            return networkInfo;
        }
        networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            return networkInfo;
        }
        networkInfo = connectivityManager.getNetworkInfo(0);
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            return networkInfo;
        }
        networkInfo = connectivityManager.getNetworkInfo(6);
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            return networkInfo;
        }
        networkInfo = connectivityManager.getNetworkInfo(9);
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            return networkInfo;
        }
        LOGGER.info("Could not find any connected network...");
        return null;
    }

    public static boolean isEthernet(NetworkInfo networkInfo) {
        return NetworkUtils.isNetworkType(networkInfo, 9);
    }

    public static boolean isWifi(NetworkInfo networkInfo) {
        return NetworkUtils.isNetworkType(networkInfo, 1) || ModelUtil.ANDROID_EMULATOR;
    }

    public static boolean isMobile(NetworkInfo networkInfo) {
        return NetworkUtils.isNetworkType(networkInfo, 0) || NetworkUtils.isNetworkType(networkInfo, 6);
    }

    public static boolean isNetworkType(NetworkInfo networkInfo, int type) {
        return networkInfo != null && networkInfo.getType() == type;
    }

    public static boolean isSSDPAwareNetwork(NetworkInfo networkInfo) {
        return NetworkUtils.isWifi(networkInfo) || NetworkUtils.isEthernet(networkInfo);
    }
}

