/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.android;

import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.jupnp.transport.impl.NetworkAddressFactoryImpl;
import org.jupnp.transport.spi.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidNetworkAddressFactory
extends NetworkAddressFactoryImpl {
    private final Logger logger = LoggerFactory.getLogger(AndroidNetworkAddressFactory.class);

    public AndroidNetworkAddressFactory(int streamListenPort, int multicastResponsePort) {
        super(streamListenPort, multicastResponsePort);
    }

    protected boolean requiresNetworkInterface() {
        return false;
    }

    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        boolean result = super.isUsableAddress(networkInterface, address);
        if (result) {
            String hostName = address.getHostAddress();
            try {
                Object target;
                Field field0;
                try {
                    field0 = InetAddress.class.getDeclaredField("holder");
                    field0.setAccessible(true);
                    target = field0.get(address);
                    field0 = target.getClass().getDeclaredField("hostName");
                }
                catch (NoSuchFieldException e) {
                    field0 = InetAddress.class.getDeclaredField("hostName");
                    target = address;
                }
                if (field0 == null || target == null || hostName == null) {
                    return false;
                }
                field0.setAccessible(true);
                field0.set(target, hostName);
            }
            catch (Exception e) {
                this.logger.error("Failed injecting hostName to work around Android InetAddress DNS bug: {}", (Object)address, (Object)e);
                return false;
            }
        }
        return result;
    }

    public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) {
        for (InetAddress localAddress : this.getInetAddresses(networkInterface)) {
            if (isIPv6 && localAddress instanceof Inet6Address) {
                return localAddress;
            }
            if (isIPv6 || !(localAddress instanceof Inet4Address)) continue;
            return localAddress;
        }
        throw new IllegalStateException("Can't find any IPv4 or IPv6 address on interface: " + networkInterface.getDisplayName());
    }

    protected void discoverNetworkInterfaces() throws InitializationException {
        try {
            super.discoverNetworkInterfaces();
        }
        catch (Exception e) {
            this.logger.warn("Exception while enumerating network interfaces, trying once more", (Throwable)e);
            super.discoverNetworkInterfaces();
        }
    }
}

