/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.android.NetworkUtils;
import org.jupnp.model.ModelUtil;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.RouterImpl;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidRouter
extends RouterImpl {
    private final Logger logger = LoggerFactory.getLogger(AndroidRouter.class);
    private final Context context;
    private final WifiManager wifiManager;
    protected WifiManager.MulticastLock multicastLock;
    protected WifiManager.WifiLock wifiLock;
    protected NetworkInfo networkInfo;
    protected BroadcastReceiver broadcastReceiver;

    public AndroidRouter(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory, Context context) throws InitializationException {
        super(configuration, protocolFactory);
        this.context = context;
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
        this.networkInfo = NetworkUtils.getConnectedNetworkInfo(context);
        if (!ModelUtil.ANDROID_EMULATOR) {
            this.broadcastReceiver = this.createConnectivityBroadcastReceiver();
            context.registerReceiver(this.broadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    protected BroadcastReceiver createConnectivityBroadcastReceiver() {
        return new ConnectivityBroadcastReceiver();
    }

    protected int getLockTimeoutMillis() {
        return 15000;
    }

    public void shutdown() throws RouterException {
        super.shutdown();
        this.unregisterBroadcastReceiver();
    }

    public boolean enable() throws RouterException {
        this.lock(this.writeLock);
        try {
            boolean enabled = super.enable();
            if (enabled && this.isWifi()) {
                this.setWiFiMulticastLock(true);
                this.setWifiLock(true);
            }
            boolean bl = enabled;
            return bl;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    public boolean disable() throws RouterException {
        this.lock(this.writeLock);
        try {
            if (this.isWifi()) {
                this.setWiFiMulticastLock(false);
                this.setWifiLock(false);
            }
            boolean bl = super.disable();
            return bl;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    public NetworkInfo getNetworkInfo() {
        return this.networkInfo;
    }

    public boolean isMobile() {
        return NetworkUtils.isMobile(this.networkInfo);
    }

    public boolean isWifi() {
        return NetworkUtils.isWifi(this.networkInfo);
    }

    public boolean isEthernet() {
        return NetworkUtils.isEthernet(this.networkInfo);
    }

    public boolean enableWiFi() {
        this.logger.info("Enabling WiFi...");
        try {
            return this.wifiManager.setWifiEnabled(true);
        }
        catch (Exception e) {
            this.logger.warn("SetWifiEnabled failed", (Throwable)e);
            return false;
        }
    }

    public void unregisterBroadcastReceiver() {
        if (this.broadcastReceiver != null) {
            this.context.unregisterReceiver(this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
    }

    protected void setWiFiMulticastLock(boolean enable) {
        if (this.multicastLock == null) {
            this.multicastLock = this.wifiManager.createMulticastLock(((Object)((Object)this)).getClass().getSimpleName());
        }
        if (enable) {
            if (this.multicastLock.isHeld()) {
                this.logger.warn("WiFi multicast lock already acquired");
            } else {
                this.logger.info("WiFi multicast lock acquired");
                this.multicastLock.acquire();
            }
        } else if (this.multicastLock.isHeld()) {
            this.logger.info("WiFi multicast lock released");
            this.multicastLock.release();
        } else {
            this.logger.warn("WiFi multicast lock already released");
        }
    }

    protected void setWifiLock(boolean enable) {
        if (this.wifiLock == null) {
            this.wifiLock = this.wifiManager.createWifiLock(3, ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (enable) {
            if (this.wifiLock.isHeld()) {
                this.logger.warn("WiFi lock already acquired");
            } else {
                this.logger.info("WiFi lock acquired");
                this.wifiLock.acquire();
            }
        } else if (this.wifiLock.isHeld()) {
            this.logger.info("WiFi lock released");
            this.wifiLock.release();
        } else {
            this.logger.warn("WiFi lock already released");
        }
    }

    protected void onNetworkTypeChange(NetworkInfo oldNetwork, NetworkInfo newNetwork) throws RouterException {
        this.logger.info("Network type changed {} => {}", (Object)(oldNetwork == null ? "" : oldNetwork.getTypeName()), (Object)(newNetwork == null ? "NONE" : newNetwork.getTypeName()));
        if (this.disable()) {
            this.logger.info("Disabled router on network type change (old network: {})", (Object)(oldNetwork == null ? "NONE" : oldNetwork.getTypeName()));
        }
        this.networkInfo = newNetwork;
        if (this.enable()) {
            this.logger.info("Enabled router on network type change (new network: {})", (Object)(newNetwork == null ? "NONE" : newNetwork.getTypeName()));
        }
    }

    protected void handleRouterExceptionOnNetworkTypeChange(RouterException e) {
        Throwable cause = Exceptions.unwrap((Throwable)e);
        if (cause instanceof InterruptedException) {
            this.logger.info("Router was interrupted", (Throwable)e);
        } else {
            this.logger.warn("Router error on network change", (Throwable)e);
        }
    }

    class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                return;
            }
            this.displayIntentInfo(intent);
            NetworkInfo newNetworkInfo = NetworkUtils.getConnectedNetworkInfo(context);
            if (AndroidRouter.this.networkInfo != null && newNetworkInfo == null) {
                for (int i = 1; i <= 3; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    AndroidRouter.this.logger.warn("{} => NONE network transition, waiting for new network... retry #{}", (Object)AndroidRouter.this.networkInfo.getTypeName(), (Object)i);
                    newNetworkInfo = NetworkUtils.getConnectedNetworkInfo(context);
                    if (newNetworkInfo != null) break;
                }
            }
            if (this.isSameNetworkType(AndroidRouter.this.networkInfo, newNetworkInfo)) {
                AndroidRouter.this.logger.info("No actual network change... ignoring event!");
            } else {
                try {
                    AndroidRouter.this.onNetworkTypeChange(AndroidRouter.this.networkInfo, newNetworkInfo);
                }
                catch (RouterException e) {
                    AndroidRouter.this.handleRouterExceptionOnNetworkTypeChange(e);
                }
            }
        }

        protected boolean isSameNetworkType(NetworkInfo network1, NetworkInfo network2) {
            if (network1 == null && network2 == null) {
                return true;
            }
            if (network1 == null || network2 == null) {
                return false;
            }
            return network1.getType() == network2.getType();
        }

        protected void displayIntentInfo(Intent intent) {
            boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
            String reason = intent.getStringExtra("reason");
            boolean isFailover = intent.getBooleanExtra("isFailover", false);
            NetworkInfo currentNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkInfo otherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
            AndroidRouter.this.logger.info("Connectivity change detected...");
            AndroidRouter.this.logger.info("EXTRA_NO_CONNECTIVITY: {}", (Object)noConnectivity);
            AndroidRouter.this.logger.info("EXTRA_REASON: {}", (Object)reason);
            AndroidRouter.this.logger.info("EXTRA_IS_FAILOVER: {}", (Object)isFailover);
            AndroidRouter.this.logger.info("EXTRA_NETWORK_INFO: {}", (Object)(currentNetworkInfo == null ? "none" : currentNetworkInfo));
            AndroidRouter.this.logger.info("EXTRA_OTHER_NETWORK_INFO: {}", (Object)(otherNetworkInfo == null ? "none" : otherNetworkInfo));
            AndroidRouter.this.logger.info("EXTRA_EXTRA_INFO: {}", (Object)intent.getStringExtra("extraInfo"));
        }
    }
}

