/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.android;

import android.os.Build;
import org.jupnp.DefaultUpnpServiceConfiguration;
import org.jupnp.android.AndroidNetworkAddressFactory;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.RecoveringUDA10DeviceDescriptorBinderImpl;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.binding.xml.UDA10ServiceDescriptorBinderSAXImpl;
import org.jupnp.model.Namespace;
import org.jupnp.model.ServerClientTokens;
import org.jupnp.transport.impl.GENAEventProcessorImpl;
import org.jupnp.transport.impl.SOAPActionProcessorImpl;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.ServletStreamServerImpl;
import org.jupnp.transport.impl.jetty.JettyServletContainer;
import org.jupnp.transport.impl.jetty.JettyStreamClientImpl;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.GENAEventProcessor;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.jupnp.transport.spi.ServletContainerAdapter;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;

public class AndroidUpnpServiceConfiguration
extends DefaultUpnpServiceConfiguration {
    public AndroidUpnpServiceConfiguration() {
        this(0, 0);
    }

    public AndroidUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort) {
        super(streamListenPort, multicastResponsePort, false);
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
    }

    protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort, int multicastResponsePort) {
        return new AndroidNetworkAddressFactory(streamListenPort, multicastResponsePort);
    }

    protected Namespace createNamespace() {
        return new Namespace("/upnp");
    }

    public StreamClient createStreamClient() {
        return new JettyStreamClientImpl(new StreamClientConfigurationImpl(this.getSyncProtocolExecutorService()){

            public String getUserAgentValue(int majorVersion, int minorVersion) {
                ServerClientTokens tokens = new ServerClientTokens(majorVersion, minorVersion);
                tokens.setOsName("Android");
                tokens.setOsVersion(Build.VERSION.RELEASE);
                return tokens.toString();
            }
        });
    }

    public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
        return new ServletStreamServerImpl(new ServletStreamServerConfigurationImpl((ServletContainerAdapter)JettyServletContainer.INSTANCE, networkAddressFactory.getStreamListenPort()));
    }

    protected DeviceDescriptorBinder createDeviceDescriptorBinderUDA10() {
        return new RecoveringUDA10DeviceDescriptorBinderImpl();
    }

    protected ServiceDescriptorBinder createServiceDescriptorBinderUDA10() {
        return new UDA10ServiceDescriptorBinderSAXImpl();
    }

    protected SOAPActionProcessor createSOAPActionProcessor() {
        return new SOAPActionProcessorImpl();
    }

    protected GENAEventProcessor createGENAEventProcessor() {
        return new GENAEventProcessorImpl();
    }

    public int getRegistryMaintenanceIntervalMillis() {
        return 3000;
    }
}

