/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.discover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jupnp.UpnpService;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.osgi.discover.UPnPEventListenerSubscriptionCallback;
import org.jupnp.osgi.impl.UPnPDeviceImpl;
import org.jupnp.osgi.impl.UPnPServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UPnPEventListenerTracker
extends ServiceTracker {
    private final Logger logger = LoggerFactory.getLogger(UPnPEventListenerTracker.class);
    private UpnpService upnpService;
    private UPnPDeviceImpl device;
    private Map<ServiceReference, List<SubscriptionCallback>> listenerCallbacks = new Hashtable<ServiceReference, List<SubscriptionCallback>>();

    public UPnPEventListenerTracker(BundleContext context, Filter filter, UpnpService upnpService, UPnPDeviceImpl device) {
        super(context, filter, null);
        this.logger.trace("ENTRY {}.{}: {} {} {} {}", new Object[]{((Object)((Object)this)).getClass().getName(), "<init>", context, filter, upnpService, device});
        this.upnpService = upnpService;
        this.device = device;
    }

    public Object addingService(ServiceReference reference) {
        this.logger.trace("ENTRY {}.{}: {}", new Object[]{((Object)((Object)this)).getClass().getName(), "addingService", reference});
        UPnPEventListener listener = (UPnPEventListener)super.addingService(reference);
        Filter filter = (Filter)reference.getProperty("upnp.filter");
        if (filter != null) {
            ArrayList<UPnPEventListenerSubscriptionCallback> callbacks = new ArrayList<UPnPEventListenerSubscriptionCallback>();
            UPnPServiceImpl[] services = (UPnPServiceImpl[])this.device.getServices();
            if (services != null) {
                Dictionary descriptions = this.device.getDescriptions(null);
                boolean all = filter.match(descriptions);
                if (all) {
                    this.logger.trace("Matched UPnPEvent listener for device {} service: ALL.", (Object)this.device.getDevice().getIdentity().getUdn().toString());
                }
                for (UPnPServiceImpl service : services) {
                    boolean match = all;
                    if (!match) {
                        Hashtable dictionary = new Hashtable();
                        for (Object key : Collections.list(descriptions.keys())) {
                            ((Dictionary)dictionary).put(key, descriptions.get(key));
                        }
                        ((Dictionary)dictionary).put("UPnP.service.id", service.getId());
                        ((Dictionary)dictionary).put("UPnP.service.type", service.getType());
                        match = filter.match(dictionary);
                        if (match) {
                            this.logger.trace("Matched UPnPEvent listener for device {} service: {}.", (Object)this.device.getDevice().getIdentity().getUdn().toString(), (Object)service.getId());
                        }
                    }
                    if (!match) continue;
                    this.logger.trace("Creating subscription callback for device {} service: {}.", (Object)this.device.getDevice().getIdentity().getUdn().toString(), (Object)service.getId());
                    UPnPEventListenerSubscriptionCallback callback = new UPnPEventListenerSubscriptionCallback(this.device, service, listener);
                    this.upnpService.getControlPoint().execute((SubscriptionCallback)callback);
                    callbacks.add(callback);
                }
            }
            this.listenerCallbacks.put(reference, callbacks);
        }
        return listener;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.logger.trace("ENTRY {}.{}: {} {}", new Object[]{((Object)((Object)this)).getClass().getName(), "removedService", reference, service});
        List<SubscriptionCallback> callbacks = this.listenerCallbacks.get(reference);
        if (callbacks != null) {
            for (SubscriptionCallback subscriptionCallback : callbacks) {
            }
        }
        this.listenerCallbacks.remove(reference);
        super.removedService(reference, service);
    }
}

