/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.osgi.impl.UPnPStateVariableImpl;
import org.jupnp.osgi.util.OSGiContext;
import org.jupnp.osgi.util.OSGiDataConverter;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPStateVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPnPActionImpl
implements UPnPAction {
    private final Logger logger = LoggerFactory.getLogger(UPnPActionImpl.class);
    private Action<?> action;

    public UPnPActionImpl(Action<?> action) {
        this.action = action;
    }

    public String getName() {
        return this.action.getName();
    }

    public String getReturnArgumentName() {
        String name = null;
        for (ActionArgument argument : this.action.getArguments()) {
            if (!argument.isReturnValue()) continue;
            name = argument.getName();
            break;
        }
        return name;
    }

    public String[] getInputArgumentNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ActionArgument argument : this.action.getInputArguments()) {
            list.add(argument.getName());
        }
        return !list.isEmpty() ? list.toArray(new String[list.size()]) : null;
    }

    public String[] getOutputArgumentNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ActionArgument argument : this.action.getOutputArguments()) {
            list.add(argument.getName());
        }
        return !list.isEmpty() ? list.toArray(new String[list.size()]) : null;
    }

    public UPnPStateVariable getStateVariable(String argumentName) {
        StateVariable variable = null;
        ActionArgument argument = this.action.getInputArgument(argumentName);
        if (argument == null) {
            argument = this.action.getOutputArgument(argumentName);
        }
        if (argument != null) {
            String name = argument.getRelatedStateVariableName();
            variable = this.action.getService().getStateVariable(name);
        }
        return argument != null ? new UPnPStateVariableImpl(variable) : null;
    }

    public Dictionary invoke(Dictionary args) throws Exception {
        ActionArgumentValue[] arguments;
        Hashtable<String, Object> output = null;
        ArrayList<ActionArgumentValue> input = new ArrayList<ActionArgumentValue>();
        if (args != null) {
            for (String key : Collections.list(args.keys())) {
                ActionArgument argument = this.action.getInputArgument(key);
                Object value = args.get(key);
                if (!value.getClass().equals(argument.getDatatype().getBuiltin().getDeclaringClass())) {
                    value = OSGiDataConverter.tojUPnPValue(argument.getDatatype().getBuiltin().getDescriptorName(), value);
                }
                input.add(new ActionArgumentValue(argument, value));
            }
        }
        ControlPoint controlPoint = OSGiContext.getUpnpService().getControlPoint();
        ActionInvocation actionInvocation = new ActionInvocation(this.action, input.toArray(new ActionArgumentValue[input.size()]));
        new ActionCallback.Default(actionInvocation, controlPoint).run();
        if (actionInvocation.getFailure() == null && (arguments = actionInvocation.getOutput()) != null && arguments.length != 0) {
            output = new Hashtable<String, Object>();
            for (ActionArgumentValue argument : arguments) {
                String name = argument.getArgument().getName();
                Object value = argument.getValue();
                if (value == null) {
                    this.logger.error("Received null value for variable {} to OSGi type {}.", (Object)name, (Object)argument.getDatatype().getDisplayString());
                    continue;
                }
                value = OSGiDataConverter.toOSGiValue(argument.getDatatype(), value);
                if (value == null) {
                    this.logger.error("Cannot convert variable {} to OSGi type {}.", (Object)name, (Object)argument.getDatatype().getDisplayString());
                }
                ((Dictionary)output).put(name, value);
            }
        }
        return output;
    }
}

