/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.Service;
import org.jupnp.osgi.impl.UPnPIconImpl;
import org.jupnp.osgi.impl.UPnPServiceImpl;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPIcon;
import org.osgi.service.upnp.UPnPService;

public class UPnPDeviceImpl
implements UPnPDevice {
    private Device<?, ?, ?> device;
    private UPnPServiceImpl[] services;
    private Hashtable<String, UPnPService> servicesIndex;
    private UPnPIconImpl[] icons;
    private Dictionary<String, Object> descriptions = new Hashtable<String, Object>();

    public UPnPDeviceImpl(Device<?, ?, ?> device) {
        Object item;
        ArrayList<Object> list;
        this.device = device;
        DeviceDetails deviceDetails = device.getDetails();
        ManufacturerDetails manufacturerDetails = deviceDetails.getManufacturerDetails();
        ModelDetails modelDetails = deviceDetails.getModelDetails();
        this.descriptions.put("DEVICE_CATEGORY", new String[]{"UPnP"});
        if (!device.isRoot()) {
            Device parent = device.getParentDevice();
            this.descriptions.put("UPnP.device.parentUDN", parent.getIdentity().getUdn().toString());
        }
        if (device.getEmbeddedDevices() != null) {
            list = new ArrayList<Object>();
            for (Device device2 : device.getEmbeddedDevices()) {
                list.add(device2.getIdentity().getUdn().toString());
            }
            this.descriptions.put("UPnP.device.childrenUDN", list.toArray(new String[0]));
        }
        this.descriptions.put("UPnP.device.friendlyName", deviceDetails.getFriendlyName());
        this.descriptions.put("UPnP.device.manufacturer", manufacturerDetails.getManufacturer());
        this.descriptions.put("UPnP.device.type", device.getType().toString());
        this.descriptions.put("UPnP.device.UDN", device.getIdentity().getUdn().toString());
        if (modelDetails.getModelDescription() != null) {
            this.descriptions.put("UPnP.device.modelDescription", modelDetails.getModelDescription());
        }
        if (modelDetails.getModelNumber() != null) {
            this.descriptions.put("UPnP.device.modelNumber", modelDetails.getModelNumber());
        }
        if (deviceDetails.getPresentationURI() != null) {
            this.descriptions.put("UPnP.presentationURL", deviceDetails.getPresentationURI().toString());
        }
        if (deviceDetails.getSerialNumber() != null) {
            this.descriptions.put("UPnP.device.serialNumber", deviceDetails.getSerialNumber());
        }
        if (manufacturerDetails.getManufacturerURI() != null) {
            this.descriptions.put("UPnP.device.manufacturerURL", manufacturerDetails.getManufacturerURI().toString());
        }
        if (modelDetails.getModelName() != null) {
            this.descriptions.put("UPnP.device.modelName", modelDetails.getModelName());
        }
        if (modelDetails.getModelURI() != null) {
            this.descriptions.put("UPnP.device.modelURL", modelDetails.getModelURI().toString());
        }
        if (deviceDetails.getUpc() != null) {
            this.descriptions.put("UPnP.device.UPC", deviceDetails.getUpc());
        }
        if (device.getServices() != null && device.getServices().length != 0) {
            list = new ArrayList();
            this.servicesIndex = new Hashtable();
            for (Device device3 : device.getServices()) {
                item = new UPnPServiceImpl((Service)device3);
                list.add(item);
                this.servicesIndex.put(((UPnPServiceImpl)item).getId(), (UPnPService)item);
            }
            this.services = list.toArray(new UPnPServiceImpl[0]);
        }
        if (device.getIcons() != null && device.getIcons().length != 0) {
            list = new ArrayList();
            for (Device device4 : device.getIcons()) {
                item = new UPnPIconImpl((Icon)device4);
                list.add(item);
            }
            this.icons = list.toArray(new UPnPIconImpl[0]);
        }
    }

    public UPnPService getService(String serviceId) {
        return this.servicesIndex != null ? this.servicesIndex.get(serviceId) : null;
    }

    public UPnPService[] getServices() {
        return this.services;
    }

    public UPnPIcon[] getIcons(String locale) {
        return this.icons;
    }

    public Dictionary getDescriptions(String locale) {
        return this.descriptions;
    }

    public Device<?, ?, ?> getDevice() {
        return this.device;
    }
}

