/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.osgi.impl.UPnPActionImpl;
import org.jupnp.osgi.impl.UPnPStateVariableImpl;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class UPnPServiceImpl
implements UPnPService {
    private Service service;
    private UPnPAction[] actions;
    private Hashtable<String, UPnPAction> actionsIndex;
    private UPnPStateVariable[] variables;
    private Hashtable<String, UPnPStateVariable> variablesIndex;

    public UPnPServiceImpl(Service service) {
        Object item;
        ArrayList<Object> list;
        this.service = service;
        if (service.getActions() != null) {
            list = new ArrayList<Object>();
            this.actionsIndex = new Hashtable();
            for (Action action : service.getActions()) {
                item = new UPnPActionImpl(action);
                list.add(item);
                this.actionsIndex.put(item.getName(), (UPnPAction)item);
            }
            this.actions = list.toArray(new UPnPAction[list.size()]);
        }
        if (service.getStateVariables() != null) {
            list = new ArrayList();
            this.variablesIndex = new Hashtable();
            for (Action action : service.getStateVariables()) {
                item = new UPnPStateVariableImpl((StateVariable<?>)action);
                list.add(item);
                this.variablesIndex.put(item.getName(), (UPnPStateVariable)item);
            }
            this.variables = list.toArray(new UPnPStateVariable[list.size()]);
        }
    }

    public String getId() {
        return this.service.getServiceId().toString();
    }

    public String getType() {
        return this.service.getServiceType().toString();
    }

    public String getVersion() {
        return String.valueOf(this.service.getServiceType().getVersion());
    }

    public UPnPAction getAction(String name) {
        return this.actionsIndex != null ? this.actionsIndex.get(name) : null;
    }

    public UPnPAction[] getActions() {
        return this.actions;
    }

    public UPnPStateVariable[] getStateVariables() {
        return this.variables;
    }

    public UPnPStateVariable getStateVariable(String name) {
        return this.variablesIndex != null ? this.variablesIndex.get(name) : null;
    }

    public Service<?, ?> getService() {
        return this.service;
    }
}

