/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.impl;

import org.jupnp.model.meta.StateVariable;
import org.jupnp.osgi.util.UPnPTypeUtil;
import org.osgi.service.upnp.UPnPStateVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPnPStateVariableImpl
implements UPnPStateVariable {
    private final Logger logger = LoggerFactory.getLogger(UPnPStateVariableImpl.class);
    private StateVariable<?> variable;

    public UPnPStateVariableImpl(StateVariable<?> variable) {
        this.variable = variable;
    }

    public String getName() {
        return this.variable.getName();
    }

    public Class getJavaDataType() {
        String type = this.variable.getTypeDetails().getDatatype().getBuiltin().getDescriptorName();
        Class clazz = UPnPTypeUtil.getUPnPClass(type);
        if (clazz == null) {
            this.logger.warn("Cannot covert UPnP type {} to UPnP Java type", (Object)type);
        }
        return clazz != null ? clazz : this.variable.getTypeDetails().getDatatype().getClass();
    }

    public String getUPnPDataType() {
        return this.variable.getTypeDetails().getDatatype().getDisplayString();
    }

    public Object getDefaultValue() {
        return this.variable.getTypeDetails().getDefaultValue();
    }

    public String[] getAllowedValues() {
        return this.variable.getTypeDetails().getAllowedValues();
    }

    public Number getMinimum() {
        return this.variable.getTypeDetails().getAllowedValueRange() != null ? Long.valueOf(this.variable.getTypeDetails().getAllowedValueRange().getMinimum()) : null;
    }

    public Number getMaximum() {
        return this.variable.getTypeDetails().getAllowedValueRange() != null ? Long.valueOf(this.variable.getTypeDetails().getAllowedValueRange().getMaximum()) : null;
    }

    public Number getStep() {
        return this.variable.getTypeDetails().getAllowedValueRange() != null ? Long.valueOf(this.variable.getTypeDetails().getAllowedValueRange().getStep()) : null;
    }

    public boolean sendsEvents() {
        return this.variable.getEventDetails().isSendEvents();
    }
}

