/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.present;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.osgi.util.OSGiContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.upnp.UPnPEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAdapter
implements UPnPEventListener {
    private final Logger logger = LoggerFactory.getLogger(DataAdapter.class);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public DataAdapter(LocalService<LocalDevice> service) {
        LocalDevice device = (LocalDevice)service.getDevice();
        String string = String.format("(&(%s=%s)(%s=%s))", "UPnP.device.UDN", device.getIdentity().getUdn().getIdentifierString(), "UPnP.service.id", service.getServiceId());
        this.logger.trace("filter: {}", (Object)string);
        try {
            BundleContext context = OSGiContext.getBundleContext();
            Filter filter = context.createFilter(string);
            Hashtable<String, Filter> properties = new Hashtable<String, Filter>();
            ((Dictionary)properties).put("upnp.filter", filter);
            context.registerService(UPnPEventListener.class.getName(), (Object)this, properties);
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Cannot create DataAdapter ({}).", (Object)service.getServiceId());
            this.logger.error(e.getMessage());
        }
    }

    public void notifyUPnPEvent(String deviceId, String serviceId, Dictionary events) {
        this.logger.trace("ENTRY {}.{}: {} {} {}", new Object[]{this.getClass().getName(), "notifyUPnPEvent", deviceId, serviceId, events});
        for (String key : Collections.list(events.keys())) {
            Object value = events.get(key);
            this.propertyChangeSupport.firePropertyChange(key, null, value);
        }
    }
}

