/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.present;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.osgi.util.OSGiDataConverter;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPStateVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UPnPActionExecutor
implements ActionExecutor {
    private final Logger logger = LoggerFactory.getLogger(UPnPActionExecutor.class);
    private UPnPAction action;

    public UPnPActionExecutor(UPnPAction action) {
        this.action = action;
    }

    public void execute(ActionInvocation<LocalService> actionInvocation) {
        this.logger.trace("ENTRY {}.{}: {}", new Object[]{this.getClass().getName(), "execute", actionInvocation});
        ActionArgumentValue[] inputs = actionInvocation.getInput();
        Hashtable<String, Object> args = new Hashtable<String, Object>();
        for (ActionArgumentValue input : inputs) {
            ActionArgument argument = input.getArgument();
            ((Dictionary)args).put(argument.getName(), OSGiDataConverter.toOSGiValue(input.getDatatype(), input.getValue()));
        }
        try {
            Dictionary out = this.action.invoke(args);
            if (out != null) {
                for (String key : Collections.list(out.keys())) {
                    Object value = out.get(key);
                    if (value == null) continue;
                    UPnPStateVariable variable = this.action.getStateVariable(key);
                    value = OSGiDataConverter.tojUPnPValue(variable.getUPnPDataType(), value);
                    try {
                        actionInvocation.setOutput(key, value);
                    }
                    catch (InvalidValueException e) {
                        this.logger.error("Error executing action {} variable {}.", (Object)this.action.getName(), (Object)key);
                        this.logger.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error executing action ({}).", (Object)this.action.getName());
            this.logger.error(e.getMessage());
        }
    }
}

