/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.discover;

import java.util.Hashtable;
import java.util.Map;
import org.jupnp.UpnpService;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.osgi.discover.UPnPEventListenerTracker;
import org.jupnp.osgi.impl.UPnPDeviceImpl;
import org.jupnp.registry.DefaultRegistryListener;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
class JUPnPRegistryListener
extends DefaultRegistryListener {
    private final Logger logger = LoggerFactory.getLogger(JUPnPRegistryListener.class);
    private Map<Device, UPnPDeviceBinding> deviceBindings = new Hashtable<Device, UPnPDeviceBinding>();
    private final BundleContext context;
    private final UpnpService upnpService;

    @Activate
    public JUPnPRegistryListener(BundleContext context, @Reference UpnpService upnpService) {
        this.context = context;
        this.upnpService = upnpService;
        upnpService.getControlPoint().getRegistry().addListener((RegistryListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.upnpService.getControlPoint().getRegistry().removeListener((RegistryListener)this);
    }

    public void deviceAdded(Registry registry, Device device) {
        this.logger.trace("ENTRY {}.{}: {} {}", new Object[]{((Object)((Object)this)).getClass().getName(), "deviceAdded", registry, device});
        UPnPDeviceImpl upnpDevice = new UPnPDeviceImpl(device);
        if (device instanceof RemoteDevice) {
            String string = String.format("(%s=%s)", "objectClass", UPnPEventListener.class.getName());
            try {
                Filter filter = this.context.createFilter(string);
                UPnPEventListenerTracker tracker = new UPnPEventListenerTracker(this.context, filter, this.upnpService, upnpDevice);
                tracker.open();
                ServiceRegistration registration = this.context.registerService(UPnPDevice.class.getName(), (Object)upnpDevice, upnpDevice.getDescriptions(null));
                this.deviceBindings.put(device, new UPnPDeviceBinding(registration, tracker));
            }
            catch (InvalidSyntaxException e) {
                this.logger.error("Cannot add remote ({}).", (Object)device.getIdentity().getUdn().toString());
                this.logger.error(e.getMessage());
            }
        }
    }

    public void deviceRemoved(Registry registry, Device device) {
        this.logger.trace("ENTRY {}.{}: {} {}", new Object[]{((Object)((Object)this)).getClass().getName(), "deviceRemoved", registry, device});
        if (device instanceof RemoteDevice) {
            UPnPDeviceBinding data = this.deviceBindings.get(device);
            if (data == null) {
                this.logger.warn("Unknown device {} removed.", (Object)device.getIdentity().getUdn().toString());
            } else {
                data.getServiceRegistration().unregister();
                data.getServiceTracker().close();
                this.deviceBindings.remove(device);
            }
        }
    }

    static class UPnPDeviceBinding {
        private ServiceRegistration reference;
        private ServiceTracker tracker;

        UPnPDeviceBinding(ServiceRegistration reference, ServiceTracker tracker) {
            this.reference = reference;
            this.tracker = tracker;
        }

        public ServiceRegistration getServiceRegistration() {
            return this.reference;
        }

        public ServiceTracker getServiceTracker() {
            return this.tracker;
        }
    }
}

