/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.discover;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.osgi.impl.UPnPDeviceImpl;
import org.jupnp.osgi.impl.UPnPServiceImpl;
import org.jupnp.osgi.util.OSGiDataConverter;
import org.osgi.service.upnp.UPnPEventListener;

public class UPnPEventListenerSubscriptionCallback
extends SubscriptionCallback {
    private UPnPDeviceImpl device;
    private UPnPServiceImpl service;
    private UPnPEventListener listener;

    protected UPnPEventListenerSubscriptionCallback(UPnPDeviceImpl device, UPnPServiceImpl service, UPnPEventListener listener) {
        super(service.getService());
        this.device = device;
        this.service = service;
        this.listener = listener;
    }

    private String getDeviceId() {
        return (String)this.device.getDescriptions(null).get("UPnP.device.UDN");
    }

    private String getServiceId() {
        return this.service.getId();
    }

    protected void failed(GENASubscription subscription, UpnpResponse responseStatus, Exception exception, String defaultMsg) {
        this.logger.error("Failed to establish subscription for device {} service {}.", (Object)this.getDeviceId(), (Object)this.getServiceId());
        if (responseStatus != null) {
            this.logger.error("Response status code: {}", (Object)responseStatus.getStatusCode());
            this.logger.error("Response status message: {}", (Object)responseStatus.getStatusMessage());
            this.logger.error("Response details: {}", (Object)responseStatus.getResponseDetails());
        }
        if (exception != null) {
            this.logger.error("Exception: {}", (Object)exception.getMessage());
        }
        this.logger.error("Default message: {}", (Object)defaultMsg);
    }

    protected void established(GENASubscription subscription) {
        this.logger.trace("Established subscription {} for device {} service {}.", new Object[]{subscription.getSubscriptionId(), this.getDeviceId(), this.getServiceId()});
    }

    protected void ended(GENASubscription subscription, CancelReason reason, UpnpResponse responseStatus) {
        if (reason == null) {
            this.logger.trace("Subscription {} for device {} service {} ended.", new Object[]{subscription.getSubscriptionId(), this.getDeviceId(), this.getServiceId()});
        } else {
            this.logger.error("Subscription {} for device {} service {} ended with reason {}.", new Object[]{subscription.getSubscriptionId(), this.getDeviceId(), this.getServiceId(), reason});
        }
    }

    protected void eventReceived(GENASubscription subscription) {
        this.logger.trace("Subscription {} for device {} service {} received event.", new Object[]{subscription.getSubscriptionId(), this.getDeviceId(), this.getServiceId()});
        Map values = subscription.getCurrentValues();
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (String key : values.keySet()) {
            StateVariableValue variable = (StateVariableValue)values.get(key);
            Object value = OSGiDataConverter.toOSGiValue(variable.getDatatype(), variable.getValue());
            if (value == null) {
                this.logger.error("Cannot convert variable {} to OSGi type {}.", (Object)variable.getStateVariable().getName(), (Object)variable.getDatatype().getDisplayString());
            }
            ((Dictionary)dictionary).put(variable.getStateVariable().getName(), value);
        }
        this.listener.notifyUPnPEvent(this.getDeviceId(), this.getServiceId(), dictionary);
    }

    protected void eventsMissed(GENASubscription subscription, int numberOfMissedEvents) {
        this.logger.warn("Subscription {} for device {} service {} missed {} events.", new Object[]{subscription.getSubscriptionId(), this.getDeviceId(), this.getServiceId(), numberOfMissedEvents});
    }

    protected void invalidMessage(RemoteGENASubscription subscription, UnsupportedDataException e) {
        this.logger.trace("Subscription {} for device {} service {} received invalid XML message causing exception {}.", new Object[]{subscription.getSubscriptionId(), this.getDeviceId(), this.getServiceId(), e.toString()});
    }
}

