/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.impl;

import org.jupnp.model.meta.ActionArgument;
import org.jupnp.osgi.impl.UPnPStateVariableImpl;
import org.jupnp.osgi.util.UPnPTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPnPActionArgumentImpl
extends UPnPStateVariableImpl {
    private final Logger logger = LoggerFactory.getLogger(UPnPActionArgumentImpl.class);
    private ActionArgument<?> argument;

    public UPnPActionArgumentImpl(ActionArgument<?> argument) {
        super(argument.getAction().getService().getStateVariable(argument.getRelatedStateVariableName()));
        this.argument = argument;
    }

    @Override
    public String getName() {
        return this.argument.getName();
    }

    @Override
    public Class getJavaDataType() {
        String type = this.argument.getDatatype().getBuiltin().getDescriptorName();
        Class clazz = UPnPTypeUtil.getUPnPClass(type);
        if (clazz == null) {
            this.logger.warn("Cannot covert UPnP type {} to UPnP Java type", (Object)type);
        }
        return clazz != null ? clazz : this.argument.getDatatype().getClass();
    }

    @Override
    public String getUPnPDataType() {
        return this.argument.getDatatype().getDisplayString();
    }
}

