/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.present;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jupnp.UpnpService;
import org.jupnp.model.DefaultServiceManager;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.ValidationException;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.osgi.present.DataAdapter;
import org.jupnp.osgi.present.UPnPActionExecutor;
import org.jupnp.osgi.present.UPnPLocalServiceImpl;
import org.jupnp.osgi.present.UPnPLocalStateVariableAccessor;
import org.jupnp.osgi.present.UPnPStateVariableAccessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPIcon;
import org.osgi.service.upnp.UPnPLocalStateVariable;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UPnPDeviceTracker
extends ServiceTracker {
    private final Logger logger = LoggerFactory.getLogger(UPnPDeviceTracker.class);
    private final UpnpService upnpService;
    private final Map<UPnPDevice, LocalDevice> registrations = new Hashtable<UPnPDevice, LocalDevice>();

    public UPnPDeviceTracker(BundleContext context, UpnpService upnpService, Filter filter) {
        super(context, filter, null);
        this.logger.trace("ENTRY {}.{}: {} {} {}", new Object[]{((Object)((Object)this)).getClass().getName(), "<init>", context, upnpService, filter});
        this.upnpService = upnpService;
    }

    public void close() {
        for (Map.Entry<UPnPDevice, LocalDevice> entry : this.registrations.entrySet()) {
            this.upnpService.getRegistry().removeDevice(entry.getValue());
        }
        this.registrations.clear();
        super.close();
    }

    private Map<Action<LocalService<DataAdapter>>, ActionExecutor> createActionExecutors(UPnPAction[] actions) {
        HashMap<Action<LocalService<DataAdapter>>, ActionExecutor> executors = new HashMap<Action<LocalService<DataAdapter>>, ActionExecutor>();
        if (actions != null) {
            for (UPnPAction action : actions) {
                ActionArgument argument;
                UPnPStateVariable variable;
                ArrayList<ActionArgument> list = new ArrayList<ActionArgument>();
                String[] names = action.getInputArgumentNames();
                if (names != null) {
                    for (String name : names) {
                        variable = action.getStateVariable(name);
                        argument = new ActionArgument(name, variable.getName(), ActionArgument.Direction.IN, false);
                        list.add(argument);
                    }
                }
                if ((names = action.getOutputArgumentNames()) != null) {
                    for (String name : names) {
                        variable = action.getStateVariable(name);
                        argument = new ActionArgument(name, variable.getName(), ActionArgument.Direction.OUT, false);
                        list.add(argument);
                    }
                }
                Action local = new Action(action.getName(), list.toArray(new ActionArgument[list.size()]));
                executors.put((Action<LocalService<DataAdapter>>)local, new UPnPActionExecutor(action));
            }
        }
        return executors;
    }

    private Map<StateVariable<LocalService<DataAdapter>>, StateVariableAccessor> createStateVariableAccessors(UPnPStateVariable[] variables) {
        HashMap<StateVariable<LocalService<DataAdapter>>, StateVariableAccessor> map = new HashMap<StateVariable<LocalService<DataAdapter>>, StateVariableAccessor>();
        if (variables != null) {
            for (UPnPStateVariable variable : variables) {
                Datatype dataType = Datatype.Builtin.getByDescriptorName((String)variable.getUPnPDataType()).getDatatype();
                StateVariable local = new StateVariable(variable.getName(), new StateVariableTypeDetails(dataType), new StateVariableEventDetails(variable.sendsEvents()));
                if (variable instanceof UPnPLocalStateVariable) {
                    map.put((StateVariable<LocalService<DataAdapter>>)local, new UPnPLocalStateVariableAccessor((UPnPLocalStateVariable)variable));
                    continue;
                }
                map.put((StateVariable<LocalService<DataAdapter>>)local, new UPnPStateVariableAccessor(variable));
            }
        }
        return map;
    }

    private Set<Class<?>> createStringConvertibleTypes() {
        HashSet set = new HashSet();
        set.add(Boolean.class);
        set.add(Byte.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Character.class);
        set.add(String.class);
        set.add(Date.class);
        return set;
    }

    private LocalService<DataAdapter>[] createServices(UPnPService[] services) throws InvalidValueException, ValidationException {
        ArrayList list = null;
        if (services != null) {
            list = new ArrayList();
            for (UPnPService service : services) {
                UPnPLocalServiceImpl local = new UPnPLocalServiceImpl(ServiceType.valueOf((String)service.getType()), ServiceId.valueOf((String)service.getId()), this.createActionExecutors(service.getActions()), this.createStateVariableAccessors(service.getStateVariables()), this.createStringConvertibleTypes(), false);
                local.setManager((ServiceManager)new DefaultServiceManager(local, DataAdapter.class));
                list.add(local);
            }
        }
        return list != null ? list.toArray(new LocalService[list.size()]) : null;
    }

    private Icon[] createIcons(UPnPIcon[] icons) throws IOException, URISyntaxException {
        ArrayList<Icon> list = null;
        if (icons != null) {
            list = new ArrayList<Icon>();
            for (UPnPIcon icon : icons) {
                InputStream in = icon.getInputStream();
                if (in == null) continue;
                Icon local = new Icon(icon.getMimeType(), icon.getWidth(), icon.getHeight(), icon.getDepth(), UUID.randomUUID().toString(), in);
                list.add(local);
            }
        }
        return list != null ? list.toArray(new Icon[list.size()]) : null;
    }

    private String getSafeString(Object object) {
        return object != null ? object.toString() : null;
    }

    private URI getSafeURI(Object object) {
        return object != null ? URI.create(object.toString()) : null;
    }

    private LocalDevice createDevice(UPnPDevice in) throws ValidationException, IOException, URISyntaxException {
        Dictionary descriptions = in.getDescriptions(null);
        DeviceIdentity identity = new DeviceIdentity(new UDN(this.getSafeString(descriptions.get("UPnP.device.UDN"))));
        DeviceType type = DeviceType.valueOf((String)this.getSafeString(descriptions.get("UPnP.device.type")));
        DeviceDetails details = new DeviceDetails(this.getSafeString(descriptions.get("UPnP.device.friendlyName")), new ManufacturerDetails(this.getSafeString(descriptions.get("UPnP.device.manufacturer")), this.getSafeURI(descriptions.get("UPnP.device.manufacturerURL"))), new ModelDetails(this.getSafeString(descriptions.get("UPnP.device.modelName")), this.getSafeString(descriptions.get("UPnP.device.modelDescription")), this.getSafeString(descriptions.get("UPnP.device.modelNumber")), this.getSafeURI(descriptions.get("UPnP.device.modelURL"))), this.getSafeString(descriptions.get("UPnP.device.serialNumber")), this.getSafeString(descriptions.get("UPnP.device.UPC")), this.getSafeURI(descriptions.get("UPnP.presentationURL")));
        Icon[] icons = this.createIcons(in.getIcons(null));
        LocalService<DataAdapter>[] services = this.createServices(in.getServices());
        return new LocalDevice(identity, type, details, icons, services);
    }

    public Object addingService(ServiceReference reference) {
        this.logger.trace("ENTRY {}.{}: {}", new Object[]{((Object)((Object)this)).getClass().getName(), "addingService", reference});
        UPnPDevice device = (UPnPDevice)super.addingService(reference);
        this.logger.trace(device.toString());
        try {
            LocalDevice local = this.createDevice(device);
            if (local != null) {
                this.upnpService.getRegistry().addDevice(local);
                this.registrations.put(device, local);
            }
        }
        catch (IOException | URISyntaxException | ValidationException e) {
            this.logger.warn("Failed to add UPnPDevice for service: {}", (Object)reference, (Object)e);
        }
        return device;
    }

    public void removedService(ServiceReference reference, Object device) {
        this.logger.trace("ENTRY {}.{}: {} {}", new Object[]{((Object)((Object)this)).getClass().getName(), "removedService", reference, device});
        LocalDevice local = this.registrations.get(device);
        if (local != null) {
            this.upnpService.getRegistry().removeDevice(local);
            this.registrations.remove(device);
        }
    }
}

