/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.present;

import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UPnPEventHandler
implements EventHandler {
    private final Logger logger = LoggerFactory.getLogger(UPnPEventHandler.class);
    private ServiceTracker tracker;

    public UPnPEventHandler(BundleContext context) {
        String string = String.format("(%s=%s)", "objectClass", UPnPEventListener.class.getName());
        try {
            Filter filter = context.createFilter(string);
            this.tracker = new ServiceTracker(context, filter, null);
            this.tracker.open();
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Cannot create UPnPEventListener tracker.");
            this.logger.error(e.getMessage());
        }
    }

    public void handleEvent(Event event) {
        this.logger.trace("ENTRY {}.{}: {}", new Object[]{this.getClass().getName(), "handleEvent", event});
        ServiceReference[] references = this.tracker.getServiceReferences();
        if (references != null) {
            for (ServiceReference reference : references) {
                boolean matches = true;
                Filter filter = (Filter)reference.getProperty("upnp.filter");
                if (filter != null) {
                    matches = event.matches(filter);
                }
                if (!matches) continue;
                UPnPEventListener listener = (UPnPEventListener)this.tracker.getService(reference);
                listener.notifyUPnPEvent((String)event.getProperty("UPnP.device.UDN"), (String)event.getProperty("UPnP.service.id"), (Dictionary)event.getProperty("upnp.events"));
            }
        }
    }
}

