/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.present;

import java.text.SimpleDateFormat;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.osgi.util.OSGiDataConverter;
import org.osgi.service.upnp.UPnPLocalStateVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UPnPLocalStateVariableAccessor
extends StateVariableAccessor {
    private final Logger logger = LoggerFactory.getLogger(UPnPLocalStateVariableAccessor.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat dateTimeTZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat timeTZFormat = new SimpleDateFormat("HH:mm:ssZ");
    private UPnPLocalStateVariable variable;

    public UPnPLocalStateVariableAccessor(UPnPLocalStateVariable variable) {
        this.variable = variable;
    }

    public Class<?> getReturnType() {
        this.logger.trace("ENTRY {}.{}: ", (Object)((Object)((Object)this)).getClass().getName(), (Object)"getReturnType");
        return this.variable.getJavaDataType();
    }

    public Object read(Object serviceImpl) throws Exception {
        this.logger.trace("ENTRY {}.{}: {}", new Object[]{((Object)((Object)this)).getClass().getName(), "read", serviceImpl});
        Object value = this.variable.getCurrentValue();
        if (value != null) {
            value = OSGiDataConverter.tojUPnPValue(this.variable.getUPnPDataType(), value);
        }
        return value;
    }
}

