/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.present;

import java.util.Dictionary;
import java.util.Hashtable;
import org.jupnp.UpnpService;
import org.jupnp.osgi.present.UPnPDeviceTracker;
import org.jupnp.osgi.present.UPnPEventHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventHandler;
import org.osgi.service.upnp.UPnPDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class UPnPPresent {
    private final Logger logger = LoggerFactory.getLogger(UPnPPresent.class);
    private static final String UPNP_EVENT_TOPIC = "org/osgi/service/upnp/UPnPEvent";
    private UPnPDeviceTracker deviceTracker;

    @Activate
    public UPnPPresent(BundleContext context, @Reference UpnpService upnpService) {
        String string = String.format("(&(%s=%s)(%s=%s))", "objectClass", UPnPDevice.class.getName(), "UPnP.export", "*");
        try {
            Filter filter = context.createFilter(string);
            this.deviceTracker = new UPnPDeviceTracker(context, upnpService, filter);
            this.deviceTracker.open();
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Cannot create UPnPDevice tracker.");
            this.logger.error("Cannot export UPnPDevices.");
            this.logger.error(e.getMessage());
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", UPNP_EVENT_TOPIC);
        context.registerService(EventHandler.class.getName(), (Object)new UPnPEventHandler(context), properties);
    }

    @Deactivate
    public void deactivate() {
        if (this.deviceTracker != null) {
            this.deviceTracker.close();
        }
    }
}

