/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.osgi.util;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.UnsignedVariableInteger;

public class OSGiDataConverter {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat dateTimeTZFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat timeTZFormat = new SimpleDateFormat("HH:mm:ssZ");

    private static boolean isInteger(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.UI1) || builtin.equals((Object)Datatype.Builtin.UI2) || builtin.equals((Object)Datatype.Builtin.I1) || builtin.equals((Object)Datatype.Builtin.I2) || builtin.equals((Object)Datatype.Builtin.I4) || builtin.equals((Object)Datatype.Builtin.INT);
    }

    private static boolean isLong(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.UI4) || builtin.equals((Object)Datatype.Builtin.TIME) || builtin.equals((Object)Datatype.Builtin.TIME_TZ);
    }

    private static boolean isFloat(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.R4) || builtin.equals((Object)Datatype.Builtin.FLOAT);
    }

    private static boolean isDouble(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.R8) || builtin.equals((Object)Datatype.Builtin.NUMBER) || builtin.equals((Object)Datatype.Builtin.FIXED144);
    }

    private static boolean isCharacter(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.CHAR);
    }

    private static boolean isString(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.STRING) || builtin.equals((Object)Datatype.Builtin.URI) || builtin.equals((Object)Datatype.Builtin.UUID);
    }

    private static boolean isDate(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.DATE) || builtin.equals((Object)Datatype.Builtin.DATETIME) || builtin.equals((Object)Datatype.Builtin.DATETIME_TZ);
    }

    private static boolean isBoolean(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.BOOLEAN);
    }

    private static boolean isByte(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.BIN_HEX);
    }

    private static boolean isBase64(Datatype.Builtin builtin) {
        return builtin.equals((Object)Datatype.Builtin.BIN_BASE64);
    }

    public static Object toOSGiValue(Datatype type, Object input) {
        Object output = null;
        if (OSGiDataConverter.isInteger(type.getBuiltin())) {
            output = OSGiDataConverter.toInteger(input);
        } else if (OSGiDataConverter.isLong(type.getBuiltin())) {
            output = OSGiDataConverter.toLong(input);
        } else if (OSGiDataConverter.isFloat(type.getBuiltin())) {
            output = OSGiDataConverter.toFloat(input);
        } else if (OSGiDataConverter.isDouble(type.getBuiltin())) {
            output = OSGiDataConverter.toDouble(input);
        } else if (OSGiDataConverter.isCharacter(type.getBuiltin())) {
            output = OSGiDataConverter.toCharacter(input);
        } else if (OSGiDataConverter.isString(type.getBuiltin())) {
            output = OSGiDataConverter.toString(input);
        } else if (OSGiDataConverter.isDate(type.getBuiltin())) {
            output = OSGiDataConverter.toDate(input);
        } else if (OSGiDataConverter.isBoolean(type.getBuiltin())) {
            output = OSGiDataConverter.toBoolean(input);
        } else if (OSGiDataConverter.isByte(type.getBuiltin())) {
            output = OSGiDataConverter.toByte(input);
        } else if (OSGiDataConverter.isBase64(type.getBuiltin())) {
            output = OSGiDataConverter.toBase64(input);
        }
        return output;
    }

    private static Integer toInteger(Object input) {
        Integer output = null;
        if (input instanceof Integer) {
            output = (Integer)input;
        } else if (input instanceof UnsignedVariableInteger) {
            output = ((UnsignedVariableInteger)input).getValue().intValue();
        }
        return output;
    }

    static long toMilliseconds(int hours, int mins, int secs) {
        return (secs + mins * 60 + hours * 3600) * 1000;
    }

    private static Long toLong(Object input) {
        Long output = null;
        if (input instanceof Long) {
            output = (Long)input;
        } else if (input instanceof UnsignedVariableInteger) {
            output = ((UnsignedVariableInteger)input).getValue().intValue();
        } else if (input instanceof Calendar) {
            Calendar calendar = (Calendar)input;
            output = OSGiDataConverter.toMilliseconds(calendar.get(11), calendar.get(12), calendar.get(13));
        }
        return output;
    }

    private static Float toFloat(Object input) {
        Float output = null;
        if (input instanceof Float) {
            output = (Float)input;
        } else if (input instanceof Double) {
            output = Float.valueOf(((Double)input).floatValue());
        }
        return output;
    }

    private static Double toDouble(Object input) {
        Double output = null;
        if (input instanceof Double) {
            output = (Double)input;
        }
        return output;
    }

    private static Character toCharacter(Object input) {
        Character output = null;
        if (input instanceof Character) {
            output = (Character)input;
        }
        return output;
    }

    private static String toString(Object input) {
        String output = null;
        if (input == null) {
            output = "";
        } else if (input instanceof String) {
            output = (String)input;
        } else if (input instanceof URI) {
            output = String.valueOf(input.toString());
        }
        return output;
    }

    private static Date toDate(Object input) {
        Date output = null;
        if (input instanceof Date) {
            output = (Date)input;
        } else if (input instanceof Calendar) {
            output = new Date(((Calendar)input).getTimeInMillis());
        }
        return output;
    }

    private static Boolean toBoolean(Object input) {
        Boolean output = null;
        if (input instanceof Boolean) {
            output = (Boolean)input;
        }
        return output;
    }

    private static byte[] toByte(Object input) {
        byte[] output = null;
        if (input == null) {
            output = new byte[]{};
        } else if (input instanceof Byte[]) {
            Byte[] Bytes = (Byte[])input;
            byte[] bytes = new byte[Bytes.length];
            for (int i = 0; i < Bytes.length; ++i) {
                bytes[i] = Bytes[i];
            }
            output = bytes;
        }
        return output;
    }

    private static byte[] toBase64(Object input) {
        byte[] output = null;
        if (input == null) {
            output = OSGiDataConverter.toByte(input);
        } else if (input instanceof Byte[]) {
            output = OSGiDataConverter.toByte(input);
        }
        if (output != null) {
            output = Base64.getDecoder().decode(output);
        }
        return output;
    }

    public static Object tojUPnPValue(String type, Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            if (type.equals("date")) {
                value = dateFormat.format(date);
            } else if (type.equals("dateTime")) {
                value = dateTimeFormat.format(date);
            } else if (type.equals("dateTime.tz")) {
                value = dateTimeTZFormat.format(date);
            }
        } else if (value instanceof Long) {
            if (type.equals("time")) {
                int offset = TimeZone.getDefault().getOffset((Long)value);
                Date date = new Date((Long)value - (long)offset);
                value = timeFormat.format(date);
            } else if (type.equals("time.tz")) {
                int offset = TimeZone.getDefault().getOffset((Long)value);
                Date date = new Date((Long)value - (long)offset);
                value = timeTZFormat.format(date);
            } else {
                value = value.toString();
            }
        } else if (value instanceof byte[]) {
            if (type.equals("bin.base64")) {
                value = Base64.getEncoder().encode((byte[])value);
            }
            byte[] bytes = value;
            Byte[] Bytes = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                Bytes[i] = bytes[i];
            }
            value = Bytes;
        } else {
            value = value.toString();
        }
        return value;
    }
}

