/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.lastchange;

import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.lastchange.Event;
import org.jupnp.support.lastchange.EventedValue;
import org.jupnp.support.lastchange.InstanceID;
import org.jupnp.support.shared.AbstractMap;
import org.jupnp.util.Exceptions;
import org.jupnp.util.io.IO;
import org.jupnp.xml.DOMParser;
import org.jupnp.xml.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class LastChangeParser
extends SAXParser {
    private final Logger logger = Logger.getLogger(LastChangeParser.class.getName());

    protected abstract String getNamespace();

    protected Set<Class<? extends EventedValue<?>>> getEventedVariables() {
        return Collections.emptySet();
    }

    protected EventedValue<?> createValue(String name, Map.Entry<String, String>[] attributes) throws Exception {
        for (Class<EventedValue<?>> evType : this.getEventedVariables()) {
            if (!evType.getSimpleName().equals(name)) continue;
            Constructor<EventedValue<?>> ctor = evType.getConstructor(Map.Entry[].class);
            return ctor.newInstance(new Object[]{attributes});
        }
        return null;
    }

    public Event parseResource(String resource) throws Exception {
        try (InputStream is = null;){
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            Event event = this.parse(IO.readLines((InputStream)is));
            return event;
        }
    }

    public Event parse(String xml) throws Exception {
        if (xml == null || xml.length() == 0) {
            throw new RuntimeException("Null or empty XML");
        }
        Event event = new Event();
        new RootHandler(event, this);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Parsing 'LastChange' event XML content");
            this.logger.fine("===================================== 'LastChange' BEGIN ============================================");
            this.logger.fine(xml);
            this.logger.fine("====================================== 'LastChange' END  ============================================");
        }
        this.parse(new InputSource(new StringReader(xml)));
        this.logger.fine("Parsed event with instances IDs: " + event.getInstanceIDs().size());
        if (this.logger.isLoggable(Level.FINEST)) {
            for (InstanceID instanceID : event.getInstanceIDs()) {
                this.logger.finest("InstanceID '" + instanceID.getId() + "' has values: " + instanceID.getValues().size());
                for (EventedValue<?> eventedValue : instanceID.getValues()) {
                    this.logger.finest(String.valueOf(eventedValue.getName()) + " => " + eventedValue.getValue());
                }
            }
        }
        return event;
    }

    public String generate(Event event) throws Exception {
        return XMLUtil.documentToFragmentString((Document)this.buildDOM(event));
    }

    protected Document buildDOM(Event event) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document d = factory.newDocumentBuilder().newDocument();
        this.generateRoot(event, d);
        return d;
    }

    protected void generateRoot(Event event, Document descriptor) {
        Element eventElement = descriptor.createElementNS(this.getNamespace(), CONSTANTS.Event.name());
        descriptor.appendChild(eventElement);
        this.generateInstanceIDs(event, descriptor, eventElement);
    }

    protected void generateInstanceIDs(Event event, Document descriptor, Element rootElement) {
        for (InstanceID instanceID : event.getInstanceIDs()) {
            if (instanceID.getId() == null) continue;
            Element instanceIDElement = XMLUtil.appendNewElement((Document)descriptor, (Element)rootElement, (String)CONSTANTS.InstanceID.name());
            instanceIDElement.setAttribute(CONSTANTS.val.name(), instanceID.getId().toString());
            for (EventedValue<?> eventedValue : instanceID.getValues()) {
                this.generateEventedValue(eventedValue, descriptor, instanceIDElement);
            }
        }
    }

    protected void generateEventedValue(EventedValue<?> eventedValue, Document descriptor, Element parentElement) {
        String name = eventedValue.getName();
        Map.Entry<String, String>[] attributes = eventedValue.getAttributes();
        if (attributes != null && attributes.length > 0) {
            Element evElement = XMLUtil.appendNewElement((Document)descriptor, (Element)parentElement, (String)name);
            Map.Entry<String, String>[] entryArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry<String, String> attr = entryArray[n2];
                evElement.setAttribute(attr.getKey(), DOMParser.escape((String)attr.getValue()));
                ++n2;
            }
        }
    }

    public static enum CONSTANTS {
        Event,
        InstanceID,
        val;


        public boolean equals(String s) {
            return this.name().equals(s);
        }
    }

    class InstanceIDHandler
    extends SAXParser.Handler<InstanceID> {
        InstanceIDHandler(InstanceID instance, SAXParser.Handler<?> parent) {
            super((Object)instance, parent);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            Map.Entry[] attributeMap = new Map.Entry[attributes.getLength()];
            int i = 0;
            while (i < attributeMap.length) {
                attributeMap[i] = new AbstractMap.SimpleEntry<String, String>(attributes.getLocalName(i), attributes.getValue(i));
                ++i;
            }
            try {
                EventedValue<?> esv = LastChangeParser.this.createValue(localName, attributeMap);
                if (esv != null) {
                    ((InstanceID)this.getInstance()).getValues().add(esv);
                }
            }
            catch (Exception ex) {
                LastChangeParser.this.logger.warning("Error reading event XML, ignoring value: " + Exceptions.unwrap((Throwable)ex));
            }
        }

        protected boolean isLastElement(String uri, String localName, String qName) {
            return CONSTANTS.InstanceID.equals(localName);
        }
    }

    class RootHandler
    extends SAXParser.Handler<Event> {
        RootHandler(Event instance, SAXParser parser) {
            super((Object)instance, parser);
        }

        RootHandler(Event instance) {
            super((Object)instance);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String valAttr;
            super.startElement(uri, localName, qName, attributes);
            if (CONSTANTS.InstanceID.equals(localName) && (valAttr = attributes.getValue(CONSTANTS.val.name())) != null) {
                InstanceID instanceID = new InstanceID(new UnsignedIntegerFourBytes(valAttr));
                ((Event)this.getInstance()).getInstanceIDs().add(instanceID);
                new InstanceIDHandler(instanceID, this);
            }
        }
    }
}

