/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jupnp.support.model.dlna.DLNAConversionIndicatorAttribute;
import org.jupnp.support.model.dlna.DLNAFlagsAttribute;
import org.jupnp.support.model.dlna.DLNAOperationsAttribute;
import org.jupnp.support.model.dlna.DLNAPlaySpeedAttribute;
import org.jupnp.support.model.dlna.DLNAProfileAttribute;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;
import org.jupnp.util.Exceptions;

public abstract class DLNAAttribute<T> {
    private static final Logger logger = Logger.getLogger(DLNAAttribute.class.getName());
    private T value;

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public abstract void setString(String var1, String var2);

    public abstract String getString();

    public static DLNAAttribute<?> newInstance(Type type, String attributeValue, String contentFormat) {
        DLNAAttribute<?> attr = null;
        int i = 0;
        while (i < type.getAttributeTypes().length && attr == null) {
            Class<DLNAAttribute<?>> attributeClass = type.getAttributeTypes()[i];
            try {
                logger.finest("Trying to parse DLNA '" + (Object)((Object)type) + "' with class: " + attributeClass.getSimpleName());
                attr = attributeClass.newInstance();
                if (attributeValue != null) {
                    attr.setString(attributeValue, contentFormat);
                }
            }
            catch (InvalidDLNAProtocolAttributeException ex) {
                logger.finest("Invalid DLNA attribute value for tested type: " + attributeClass.getSimpleName() + " - " + ex.getMessage());
                attr = null;
            }
            catch (Exception ex) {
                logger.severe("Error instantiating DLNA attribute of type '" + (Object)((Object)type) + "' with value: " + attributeValue);
                logger.log(Level.SEVERE, "Exception root cause: ", Exceptions.unwrap((Throwable)ex));
            }
            ++i;
        }
        return attr;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + this.getValue() + "'";
    }

    public static enum Type {
        DLNA_ORG_PN("DLNA.ORG_PN", DLNAProfileAttribute.class),
        DLNA_ORG_OP("DLNA.ORG_OP", DLNAOperationsAttribute.class),
        DLNA_ORG_PS("DLNA.ORG_PS", DLNAPlaySpeedAttribute.class),
        DLNA_ORG_CI("DLNA.ORG_CI", DLNAConversionIndicatorAttribute.class),
        DLNA_ORG_FLAGS("DLNA.ORG_FLAGS", DLNAFlagsAttribute.class);

        private static Map<String, Type> byName;
        private String attributeName;
        private Class<? extends DLNAAttribute<?>>[] attributeTypes;

        static {
            byName = new HashMap<String, Type>(){
                private static final long serialVersionUID = -4611773458029624524L;
                {
                    Type[] typeArray = Type.values();
                    int n = typeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type t = typeArray[n2];
                        this.put(t.getAttributeName().toUpperCase(Locale.ROOT), t);
                        ++n2;
                    }
                }
            };
        }

        @SafeVarargs
        private Type(String attributeName, Class<? extends DLNAAttribute<?>> ... attributeClass) {
            this.attributeName = attributeName;
            this.attributeTypes = attributeClass;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Class<? extends DLNAAttribute<?>>[] getAttributeTypes() {
            return this.attributeTypes;
        }

        public static Type valueOfAttributeName(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            return byName.get(attributeName.toUpperCase(Locale.ROOT));
        }
    }
}

