/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.avtransport.lastchange.AVTransportVariable;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAPlaySpeedAttribute
extends DLNAAttribute<AVTransportVariable.TransportPlaySpeed[]> {
    public DLNAPlaySpeedAttribute() {
        this.setValue(new AVTransportVariable.TransportPlaySpeed[0]);
    }

    public DLNAPlaySpeedAttribute(AVTransportVariable.TransportPlaySpeed[] speeds) {
        this.setValue(speeds);
    }

    public DLNAPlaySpeedAttribute(String[] speeds) {
        AVTransportVariable.TransportPlaySpeed[] sp = new AVTransportVariable.TransportPlaySpeed[speeds.length];
        try {
            int i = 0;
            while (i < speeds.length) {
                sp[i] = new AVTransportVariable.TransportPlaySpeed(speeds[i]);
                ++i;
            }
        }
        catch (InvalidValueException invalidValueException) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA play speeds.");
        }
        this.setValue(sp);
    }

    @Override
    public void setString(String s, String cf) {
        AVTransportVariable.TransportPlaySpeed[] value = null;
        if (s != null && s.length() != 0) {
            String[] speeds = s.split(",");
            try {
                value = new AVTransportVariable.TransportPlaySpeed[speeds.length];
                int i = 0;
                while (i < speeds.length) {
                    value[i] = new AVTransportVariable.TransportPlaySpeed(speeds[i]);
                    ++i;
                }
            }
            catch (InvalidValueException invalidValueException) {
                value = null;
            }
        }
        if (value == null) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA play speeds from: " + s);
        }
        this.setValue(value);
    }

    @Override
    public String getString() {
        String s = "";
        AVTransportVariable.TransportPlaySpeed[] transportPlaySpeedArray = (AVTransportVariable.TransportPlaySpeed[])this.getValue();
        int n = transportPlaySpeedArray.length;
        int n2 = 0;
        while (n2 < n) {
            AVTransportVariable.TransportPlaySpeed speed = transportPlaySpeedArray[n2];
            if (!((String)speed.getValue()).equals("1")) {
                s = String.valueOf(s) + (s.length() == 0 ? "" : ",") + speed;
            }
            ++n2;
        }
        return s;
    }
}

