/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.item;

import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.AudioItem;
import org.jupnp.support.model.item.Item;

public class MusicTrack
extends AudioItem {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.audioItem.musicTrack");

    public MusicTrack() {
        this.setClazz(CLASS);
    }

    public MusicTrack(Item other) {
        super(other);
    }

    public MusicTrack(String id, Container parent, String title, String creator, String album, String artist, Res ... resource) {
        this(id, parent.getId(), title, creator, album, artist, resource);
    }

    public MusicTrack(String id, Container parent, String title, String creator, String album, PersonWithRole artist, Res ... resource) {
        this(id, parent.getId(), title, creator, album, artist, resource);
    }

    public MusicTrack(String id, String parentID, String title, String creator, String album, String artist, Res ... resource) {
        this(id, parentID, title, creator, album, artist == null ? null : new PersonWithRole(artist), resource);
    }

    public MusicTrack(String id, String parentID, String title, String creator, String album, PersonWithRole artist, Res ... resource) {
        super(id, parentID, title, creator, resource);
        this.setClazz(CLASS);
        if (album != null) {
            this.setAlbum(album);
        }
        if (artist != null) {
            this.addProperty(new DIDLObject.Property.UPNP.ARTIST(artist));
        }
    }

    public PersonWithRole getFirstArtist() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ARTIST.class);
    }

    public PersonWithRole[] getArtists() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ARTIST.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public MusicTrack setArtists(PersonWithRole[] artists) {
        this.removeProperties(DIDLObject.Property.UPNP.ARTIST.class);
        PersonWithRole[] personWithRoleArray = artists;
        int n = artists.length;
        int n2 = 0;
        while (n2 < n) {
            PersonWithRole artist = personWithRoleArray[n2];
            this.addProperty(new DIDLObject.Property.UPNP.ARTIST(artist));
            ++n2;
        }
        return this;
    }

    public String getAlbum() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ALBUM.class);
    }

    public MusicTrack setAlbum(String album) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.ALBUM(album));
        return this;
    }

    public Integer getOriginalTrackNumber() {
        return (Integer)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ORIGINAL_TRACK_NUMBER.class);
    }

    public MusicTrack setOriginalTrackNumber(Integer number) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.ORIGINAL_TRACK_NUMBER(number));
        return this;
    }

    public String getFirstPlaylist() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.PLAYLIST.class);
    }

    public String[] getPlaylists() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.PLAYLIST.class);
        return list.toArray(new String[list.size()]);
    }

    public MusicTrack setPlaylists(String[] playlists) {
        this.removeProperties(DIDLObject.Property.UPNP.PLAYLIST.class);
        String[] stringArray = playlists;
        int n = playlists.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.addProperty(new DIDLObject.Property.UPNP.PLAYLIST(s));
            ++n2;
        }
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public MusicTrack setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public Person getFirstContributor() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.CONTRIBUTOR.class);
    }

    public Person[] getContributors() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.CONTRIBUTOR.class);
        return list.toArray(new Person[list.size()]);
    }

    public MusicTrack setContributors(Person[] contributors) {
        this.removeProperties(DIDLObject.Property.DC.CONTRIBUTOR.class);
        Person[] personArray = contributors;
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            Person p = personArray[n2];
            this.addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(p));
            ++n2;
        }
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public MusicTrack setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }
}

