/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jupnp.binding.LocalServiceBinder;
import org.jupnp.binding.LocalServiceBindingException;
import org.jupnp.binding.annotations.AnnotationActionBinder;
import org.jupnp.binding.annotations.AnnotationStateVariableBinder;
import org.jupnp.binding.annotations.UpnpAction;
import org.jupnp.binding.annotations.UpnpService;
import org.jupnp.binding.annotations.UpnpServiceId;
import org.jupnp.binding.annotations.UpnpServiceType;
import org.jupnp.binding.annotations.UpnpStateVariable;
import org.jupnp.binding.annotations.UpnpStateVariables;
import org.jupnp.model.ValidationException;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.action.QueryStateVariableExecutor;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.QueryStateVariableAction;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.FieldStateVariableAccessor;
import org.jupnp.model.state.GetterStateVariableAccessor;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDAServiceId;
import org.jupnp.model.types.UDAServiceType;
import org.jupnp.model.types.csv.CSV;
import org.jupnp.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationLocalServiceBinder
implements LocalServiceBinder {
    private Logger log = LoggerFactory.getLogger(AnnotationLocalServiceBinder.class);

    @Override
    public LocalService read(Class<?> clazz) throws LocalServiceBindingException {
        this.log.trace("Reading and binding annotations of service implementation class: " + clazz);
        if (clazz.isAnnotationPresent(UpnpService.class)) {
            UpnpService annotation = clazz.getAnnotation(UpnpService.class);
            UpnpServiceId idAnnotation = annotation.serviceId();
            UpnpServiceType typeAnnotation = annotation.serviceType();
            ServiceId serviceId = idAnnotation.namespace().equals("upnp-org") ? new UDAServiceId(idAnnotation.value()) : new ServiceId(idAnnotation.namespace(), idAnnotation.value());
            ServiceType serviceType = typeAnnotation.namespace().equals("schemas-upnp-org") ? new UDAServiceType(typeAnnotation.value(), typeAnnotation.version()) : new ServiceType(typeAnnotation.namespace(), typeAnnotation.value(), typeAnnotation.version());
            boolean supportsQueryStateVariables = annotation.supportsQueryStateVariables();
            Set<Class> stringConvertibleTypes = this.readStringConvertibleTypes(annotation.stringConvertibleTypes());
            return this.read(clazz, serviceId, serviceType, supportsQueryStateVariables, stringConvertibleTypes);
        }
        throw new LocalServiceBindingException("Given class is not an @UpnpService");
    }

    @Override
    public LocalService read(Class<?> clazz, ServiceId id, ServiceType type, boolean supportsQueryStateVariables, Class[] stringConvertibleTypes) throws LocalServiceBindingException {
        return this.read(clazz, id, type, supportsQueryStateVariables, new HashSet<Class>(Arrays.asList(stringConvertibleTypes)));
    }

    /*
     * Unable to fully structure code
     */
    public LocalService read(Class<?> clazz, ServiceId id, ServiceType type, boolean supportsQueryStateVariables, Set<Class> stringConvertibleTypes) throws LocalServiceBindingException {
        stateVariables = this.readStateVariables(clazz, stringConvertibleTypes);
        actions = this.readActions(clazz, stateVariables, stringConvertibleTypes);
        if (supportsQueryStateVariables) {
            actions.put(new QueryStateVariableAction<S>(), new QueryStateVariableExecutor());
        }
        try {
            return new LocalService<T>(type, id, actions, stateVariables, stringConvertibleTypes, supportsQueryStateVariables);
        }
        catch (ValidationException ex) {
            this.log.error("Could not validate device model: " + ex.toString());
            ** for (validationError : ex.getErrors())
        }
lbl-1000:
        // 1 sources

        {
            this.log.error(validationError.toString());
            continue;
        }
lbl13:
        // 1 sources

        throw new LocalServiceBindingException("Validation of model failed, check the log");
    }

    protected Set<Class> readStringConvertibleTypes(Class[] declaredTypes) throws LocalServiceBindingException {
        Class[] classArray = declaredTypes;
        int n = declaredTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class stringConvertibleType = classArray[n2];
            if (!Modifier.isPublic(stringConvertibleType.getModifiers())) {
                throw new LocalServiceBindingException("Declared string-convertible type must be public: " + stringConvertibleType);
            }
            try {
                stringConvertibleType.getConstructor(String.class);
            }
            catch (NoSuchMethodException ex) {
                throw new LocalServiceBindingException("Declared string-convertible type needs a public single-argument String constructor: " + stringConvertibleType);
            }
            ++n2;
        }
        HashSet<Class> stringConvertibleTypes = new HashSet<Class>(Arrays.asList(declaredTypes));
        stringConvertibleTypes.add(URI.class);
        stringConvertibleTypes.add(URL.class);
        stringConvertibleTypes.add(CSV.class);
        return stringConvertibleTypes;
    }

    protected Map<StateVariable, StateVariableAccessor> readStateVariables(Class<?> clazz, Set<Class> stringConvertibleTypes) throws LocalServiceBindingException {
        HashMap<StateVariable, StateVariableAccessor> map = new HashMap<StateVariable, StateVariableAccessor>();
        if (clazz.isAnnotationPresent(UpnpStateVariables.class)) {
            UpnpStateVariables variables = clazz.getAnnotation(UpnpStateVariables.class);
            UpnpStateVariable[] upnpStateVariableArray = variables.value();
            int n = upnpStateVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                UpnpStateVariable v = upnpStateVariableArray[n2];
                if (v.name().length() == 0) {
                    throw new LocalServiceBindingException("Class-level @UpnpStateVariable name attribute value required");
                }
                String javaPropertyName = AnnotationLocalServiceBinder.toJavaStateVariableName(v.name());
                Method getter = Reflections.getGetterMethod(clazz, javaPropertyName);
                Field field = Reflections.getField(clazz, javaPropertyName);
                StateVariableAccessor accessor = null;
                if (getter != null && field != null) {
                    accessor = variables.preferFields() ? new FieldStateVariableAccessor(field) : new GetterStateVariableAccessor(getter);
                } else if (field != null) {
                    accessor = new FieldStateVariableAccessor(field);
                } else if (getter != null) {
                    accessor = new GetterStateVariableAccessor(getter);
                } else {
                    this.log.trace("No field or getter found for state variable, skipping accessor: " + v.name());
                }
                StateVariable stateVar = new AnnotationStateVariableBinder(v, v.name(), accessor, stringConvertibleTypes).createStateVariable();
                map.put(stateVar, accessor);
                ++n2;
            }
        }
        for (Field field : Reflections.getFields(clazz, UpnpStateVariable.class)) {
            UpnpStateVariable svAnnotation = field.getAnnotation(UpnpStateVariable.class);
            FieldStateVariableAccessor accessor = new FieldStateVariableAccessor(field);
            StateVariable stateVar = new AnnotationStateVariableBinder(svAnnotation, svAnnotation.name().length() == 0 ? AnnotationLocalServiceBinder.toUpnpStateVariableName(field.getName()) : svAnnotation.name(), accessor, stringConvertibleTypes).createStateVariable();
            map.put(stateVar, accessor);
        }
        for (Method getter : Reflections.getMethods(clazz, UpnpStateVariable.class)) {
            String propertyName = Reflections.getMethodPropertyName(getter.getName());
            if (propertyName == null) {
                throw new LocalServiceBindingException("Annotated method is not a getter method (: " + getter);
            }
            if (getter.getParameterTypes().length > 0) {
                throw new LocalServiceBindingException("Getter method defined as @UpnpStateVariable can not have parameters: " + getter);
            }
            UpnpStateVariable svAnnotation = getter.getAnnotation(UpnpStateVariable.class);
            GetterStateVariableAccessor accessor = new GetterStateVariableAccessor(getter);
            StateVariable stateVar = new AnnotationStateVariableBinder(svAnnotation, svAnnotation.name().length() == 0 ? AnnotationLocalServiceBinder.toUpnpStateVariableName(propertyName) : svAnnotation.name(), accessor, stringConvertibleTypes).createStateVariable();
            map.put(stateVar, accessor);
        }
        return map;
    }

    protected Map<Action, ActionExecutor> readActions(Class<?> clazz, Map<StateVariable, StateVariableAccessor> stateVariables, Set<Class> stringConvertibleTypes) throws LocalServiceBindingException {
        HashMap<Action, ActionExecutor> map = new HashMap<Action, ActionExecutor>();
        for (Method method : Reflections.getMethods(clazz, UpnpAction.class)) {
            AnnotationActionBinder actionBinder = new AnnotationActionBinder(method, stateVariables, stringConvertibleTypes);
            Action action = actionBinder.appendAction(map);
            if (!this.isActionExcluded(action)) continue;
            map.remove(action);
        }
        return map;
    }

    protected boolean isActionExcluded(Action action) {
        return false;
    }

    static String toUpnpStateVariableName(String javaName) {
        if (javaName.length() < 1) {
            throw new IllegalArgumentException("Variable name must be at least 1 character long");
        }
        return String.valueOf(javaName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + javaName.substring(1);
    }

    static String toJavaStateVariableName(String upnpName) {
        if (upnpName.length() < 1) {
            throw new IllegalArgumentException("Variable name must be at least 1 character long");
        }
        return String.valueOf(upnpName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + upnpName.substring(1);
    }

    static String toUpnpActionName(String javaName) {
        if (javaName.length() < 1) {
            throw new IllegalArgumentException("Action name must be at least 1 character long");
        }
        return String.valueOf(javaName.substring(0, 1).toUpperCase(Locale.ENGLISH)) + javaName.substring(1);
    }

    static String toJavaActionName(String upnpName) {
        if (upnpName.length() < 1) {
            throw new IllegalArgumentException("Variable name must be at least 1 character long");
        }
        return String.valueOf(upnpName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + upnpName.substring(1);
    }
}

