/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.gena;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.model.meta.Service;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.UnsignedIntegerFourBytes;

public abstract class GENASubscription<S extends Service> {
    protected final S service;
    protected volatile String subscriptionId;
    protected volatile int requestedDurationSeconds = 1800;
    protected volatile int actualDurationSeconds;
    protected volatile UnsignedIntegerFourBytes currentSequence;
    protected Map<String, StateVariableValue<S>> currentValues = new ConcurrentHashMap<String, StateVariableValue<S>>();

    protected GENASubscription(S service) {
        this.service = service;
    }

    public GENASubscription(S service, int requestedDurationSeconds) {
        this(service);
        this.requestedDurationSeconds = requestedDurationSeconds;
    }

    public S getService() {
        return this.service;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public int getRequestedDurationSeconds() {
        return this.requestedDurationSeconds;
    }

    public int getActualDurationSeconds() {
        return this.actualDurationSeconds;
    }

    public void setActualSubscriptionDurationSeconds(int seconds) {
        this.actualDurationSeconds = seconds;
    }

    public UnsignedIntegerFourBytes getCurrentSequence() {
        return this.currentSequence;
    }

    public Map<String, StateVariableValue<S>> getCurrentValues() {
        return this.currentValues;
    }

    public abstract void established();

    public abstract void eventReceived();

    public String toString() {
        return "(GENASubscription, SID: " + this.getSubscriptionId() + ", SEQUENCE: " + this.getCurrentSequence() + ")";
    }
}

