/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.ControlPointImpl;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ProtocolFactoryImpl;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.RouterImpl;
import org.jupnp.util.Exceptions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.jupnp.upnpservice"})
@Designate(ocd=Config.class)
public class UpnpServiceImpl
implements UpnpService {
    private final Logger logger = LoggerFactory.getLogger(UpnpServiceImpl.class);
    protected boolean isConfigured = false;
    protected boolean isRunning = false;
    private volatile boolean isInitialSearchEnabled = true;
    private final Object lock = new Object();
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;
    protected ControlPoint controlPoint;
    protected Router router;
    protected ScheduledExecutorService scheduledExecutorService;
    protected volatile ScheduledFuture<?> scheduledFuture;

    public UpnpServiceImpl() {
    }

    public UpnpServiceImpl(UpnpServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    @Activate
    public void activate(Config config) {
        this.scheduledFuture = null;
        this.scheduledExecutorService = UpnpServiceImpl.createExecutor();
        this.isInitialSearchEnabled = config.initialSearchEnabled();
        this.startup();
    }

    @Deactivate
    public void deactivate() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledExecutorService.shutdownNow();
        this.shutdown();
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "Upnp Service Delayed Startup Thread");
            thread.setUncaughtExceptionHandler((thread1, exception) -> {
                throw new IllegalStateException(exception);
            });
            return thread;
        });
    }

    @Reference
    public void setUpnpServiceConfiguration(UpnpServiceConfiguration configuration) {
        this.configuration = configuration;
        if (this.isRunning) {
            this.restart(true);
        }
    }

    public void unsetUpnpServiceConfiguration(UpnpServiceConfiguration configuration) {
        this.configuration = null;
    }

    @Reference
    public void setHttpService(HttpService httpService) {
        if (this.isRunning) {
            this.shutdown(false);
            this.delayedStartup(1500);
        }
    }

    public void unsetHttpService(HttpService httpService) {
        if (this.isRunning) {
            this.shutdown(false);
            this.delayedStartup(1500);
        }
    }

    protected ProtocolFactory createProtocolFactory() {
        return new ProtocolFactoryImpl(this);
    }

    protected Registry createRegistry(ProtocolFactory protocolFactory) {
        return new RegistryImpl(this);
    }

    protected Router createRouter(ProtocolFactory protocolFactory, Registry registry) {
        return new RouterImpl(this.getConfiguration(), protocolFactory);
    }

    protected ControlPoint createControlPoint(ProtocolFactory protocolFactory, Registry registry) {
        return new ControlPointImpl(this.getConfiguration(), protocolFactory, registry);
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown(false);
    }

    protected void shutdown(boolean separateThread) {
        Runnable shutdown = () -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning) {
                    this.logger.info("Shutting down UPnP service...");
                    this.shutdownRegistry();
                    this.shutdownConfiguration();
                    this.shutdownRouter();
                    this.logger.info("UPnP service shutdown completed");
                    this.isRunning = false;
                }
            }
        };
        if (separateThread) {
            new Thread(shutdown).start();
        } else {
            shutdown.run();
        }
    }

    private void restart(boolean separateThread) {
        Runnable restart = () -> {
            this.shutdown();
            this.startup();
        };
        if (separateThread) {
            new Thread(restart).start();
        } else {
            restart.run();
        }
    }

    protected void shutdownRegistry() {
        this.getRegistry().shutdown();
    }

    protected void shutdownRouter() {
        try {
            this.getRouter().shutdown();
        }
        catch (RouterException e) {
            Throwable cause = Exceptions.unwrap(e);
            if (cause instanceof InterruptedException) {
                this.logger.debug("Router shutdown was interrupted", (Throwable)e);
            }
            throw new RuntimeException("Router error on shutdown", e);
        }
    }

    protected void shutdownConfiguration() {
        this.getConfiguration().shutdown();
    }

    private void delayedStartup(int msDelay) {
        Runnable startup = this::startup;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = this.scheduledExecutorService.schedule(startup, (long)msDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                this.logger.info("Starting UPnP service...");
                this.logger.debug("Using configuration: {}", (Object)this.getConfiguration().getClass().getName());
                this.protocolFactory = this.createProtocolFactory();
                this.registry = this.createRegistry(this.protocolFactory);
                this.router = this.createRouter(this.protocolFactory, this.registry);
                try {
                    this.router.enable();
                }
                catch (RouterException e) {
                    throw new RuntimeException("Enabling network router failed", e);
                }
                this.controlPoint = this.createControlPoint(this.protocolFactory, this.registry);
                this.logger.debug("UPnP service started successfully");
                this.isRunning = true;
                if (this.isInitialSearchEnabled) {
                    this.controlPoint.search(new STAllHeader());
                }
            }
        }
    }

    @ObjectClassDefinition(id="org.jupnp.upnpservice", name="jUPnP service configuration", description="Configuration for jUPnP OSGi service")
    public static @interface Config {
        @AttributeDefinition(name="initialSearchEnabled", description="Enable initial search when starting jUPnP service.")
        public boolean initialSearchEnabled() default true;
    }
}

