/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIVariant;

public final class JIPointer
implements Serializable {
    private static final long serialVersionUID = -3434037097460692619L;
    private Object referent = null;
    private boolean isReferenceTypePtr = false;
    private boolean isDeffered = false;
    private int referentId = -1;
    private boolean isNull = false;
    private int flags = 0;

    private JIPointer() {
    }

    public JIPointer(Class value, boolean isReferenceTypePtr) {
        if (value == null) {
            value = Integer.class;
            isReferenceTypePtr = true;
            this.isNull = true;
        }
        this.referent = value;
        this.isReferenceTypePtr = isReferenceTypePtr;
    }

    public JIPointer(Object value, boolean isReferenceTypePtr) {
        if (value == null) {
            value = new Integer(0);
            isReferenceTypePtr = true;
            this.isNull = true;
        }
        this.referent = value;
        this.referentId = new Object().hashCode();
        this.isReferenceTypePtr = isReferenceTypePtr;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    public JIPointer(Object value) {
        this(value, false);
    }

    public Object getReferent() {
        return this.isNull ? null : this.referent;
    }

    void encode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG) {
        FLAG |= this.flags;
        if (this.isNull) {
            JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), defferedPointers, FLAG);
            return;
        }
        if (!this.isNull && (this.isDeffered || (FLAG & 8) == 8)) {
            int referentIdToPut = this.referentId == -1 ? this.referent.hashCode() : this.referentId;
            JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(referentIdToPut), defferedPointers, FLAG);
            this.isDeffered = false;
            this.isReferenceTypePtr = true;
            defferedPointers.add(this);
            return;
        }
        if (!this.isNull && !this.isReferenceTypePtr) {
            int referentIdToPut = this.referentId == -1 ? this.referent.hashCode() : this.referentId;
            JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(referentIdToPut), defferedPointers, FLAG);
        }
        try {
            if (!this.isNull && this.referent.getClass().equals(JIVariant.class) && ((JIVariant)this.referent).isArray()) {
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(((Object[])((JIVariant)this.referent).getObject()).length), defferedPointers, FLAG);
            }
        }
        catch (JIException e) {
            throw new JIRuntimeException(e.getErrorCode());
        }
        JIMarshalUnMarshalHelper.serialize(ndr, this.referent.getClass(), this.referent, defferedPointers, FLAG);
    }

    JIPointer decode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG, Map additionalData) {
        JIPointer retVal = new JIPointer();
        retVal.setFlags(this.flags);
        retVal.isNull = this.isNull;
        if (this.isDeffered || ((FLAG |= this.flags) & 8) == 8) {
            retVal.referentId = (Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, defferedPointers, FLAG, additionalData);
            retVal.referent = this.referent;
            if (retVal.referentId == 0) {
                retVal.isNull = true;
                retVal.isDeffered = false;
                return retVal;
            }
            retVal.isDeffered = false;
            retVal.isReferenceTypePtr = true;
            defferedPointers.add(retVal);
            return retVal;
        }
        if (!this.isReferenceTypePtr) {
            retVal.referentId = (Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, defferedPointers, FLAG, additionalData);
            retVal.referent = this.referent;
            if (retVal.referentId == 0) {
                retVal.isNull = true;
                return retVal;
            }
        }
        retVal.referent = JIMarshalUnMarshalHelper.deSerialize(ndr, this.referent, defferedPointers, FLAG, additionalData);
        return retVal;
    }

    void setDeffered(boolean deffered) {
        this.isDeffered = deffered;
    }

    boolean getDeffered() {
        return this.isDeffered;
    }

    void setReferent(int referent) {
        this.referentId = referent;
    }

    public boolean isReference() {
        return this.isReferenceTypePtr;
    }

    public Integer getReferentIdentifier() {
        return new Integer(this.referentId);
    }

    int getLength() {
        if (this.isNull) {
            return 4;
        }
        if (this.referent instanceof Class) {
            return 4 + JIMarshalUnMarshalHelper.getLengthInBytes((Class)this.referent, this.referent, 0);
        }
        return 4 + JIMarshalUnMarshalHelper.getLengthInBytes(this.referent.getClass(), this.referent, 0);
    }

    void replaceSelfWithNewPointer(JIPointer replacement) {
        this.isDeffered = replacement.isDeffered;
        this.isNull = replacement.isNull;
        this.isReferenceTypePtr = replacement.isReferenceTypePtr;
        this.referent = replacement.referent;
    }

    public boolean isNull() {
        return this.isNull;
    }

    void setValue(Object value) {
        this.referent = value;
    }

    public String toString() {
        return this.referent == null ? "[null]" : "[" + this.referent.toString() + "]";
    }
}

