/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;

public class ForgedMethodHistory {
    private final ForgedMethodHistory prevHistory;
    private final String sourceElement;
    private final String targetPropertyName;
    private final Type targetType;
    private final Type sourceType;
    private final boolean usePropertyNames;
    private String elementType;

    public ForgedMethodHistory(ForgedMethodHistory history, String sourceElement, String targetPropertyName, Type sourceType, Type targetType, boolean usePropertyNames, String elementType) {
        this.prevHistory = history;
        this.sourceElement = sourceElement;
        this.targetPropertyName = targetPropertyName;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.usePropertyNames = usePropertyNames;
        this.elementType = elementType;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public String createSourcePropertyErrorMessage() {
        return this.conditionallyCapitalizedElementType() + " \"" + this.getSourceType() + " " + this.stripBrackets(this.getDottedSourceElement()) + "\"";
    }

    private String conditionallyCapitalizedElementType() {
        if ("property".equals(this.elementType)) {
            return this.elementType;
        }
        return Strings.capitalize(this.elementType);
    }

    public String createTargetPropertyName() {
        return this.stripBrackets(this.getDottedTargetPropertyName());
    }

    private String getDottedSourceElement() {
        if (this.prevHistory == null) {
            return this.sourceElement;
        }
        if (this.usePropertyNames) {
            return this.getCorrectDottedPath(this.prevHistory.getDottedSourceElement(), this.sourceElement);
        }
        return this.prevHistory.getDottedSourceElement();
    }

    private String getDottedTargetPropertyName() {
        if (this.prevHistory == null) {
            return this.targetPropertyName;
        }
        if (this.usePropertyNames) {
            return this.getCorrectDottedPath(this.prevHistory.getDottedTargetPropertyName(), this.targetPropertyName);
        }
        return this.prevHistory.getDottedTargetPropertyName();
    }

    private String getCorrectDottedPath(String previousPath, String currentProperty) {
        if ("map key".equals(this.elementType)) {
            return this.stripBrackets(previousPath) + "{:key}";
        }
        if ("map value".equals(this.elementType)) {
            return this.stripBrackets(previousPath) + "{:value}";
        }
        return previousPath + "." + currentProperty;
    }

    private String stripBrackets(String dottedName) {
        if (dottedName.endsWith("[]") || dottedName.endsWith("{}")) {
            dottedName = dottedName.substring(0, dottedName.length() - 2);
        }
        return dottedName;
    }
}

